# Reporting Security Vulnerabilities

The GraalVM team values the independent security research community and believes that responsible disclosure of security vulnerabilities in GraalVM helps us ensure the security and privacy of all our users.

If you believe you have found a security vulnerability, please submit a report to secalert_us@oracle.com preferably with a proof of concept. Please refer to [Reporting Vulnerabilities](https://www.oracle.com/corporate/security-practices/assurance/vulnerability/reporting.html) for additional information including our public encryption key for secure email. We ask that you do not contact project contributors directly or through other channels about a report.

### Security Updates, Alerts and Bulletins

GraalVM Community Edition security updates will be released on a quarterly basis in conjunction with the Oracle GraalVM security updates that are part of the Oracle Critical Patch Update program. Security updates are released on the Tuesday closest to the 17th day of January, April, July and October. A pre-release announcement will be published on the Thursday preceding each Critical Patch Update release. For additional information including past advisories, please refer to [Security Alerts](https://www.oracle.com/security-alerts/).

### Security-Related Information

Please refer to the [GraalVM Security Guide](https://www.graalvm.org/docs/security-guide/) for security related topics such as how to support trusted and less trusted code execution using the Truffle language framework, or compiler mitigations for transitive execution attacks. However please note that we do not currently support the execution of untrusted or adversarial code. Non-vulnerability related security issues may be discussed on GitHub Issues or the Security channel in the [GraalVM Slack Workspace](https://graalvm.slack.com/)