/* illuminate.vapi generated by valac 0.56.18-dirty, do not modify. */

namespace Kangaroo {
	namespace Illuminate {
		namespace Contracts {
			namespace CodeGen {
				[CCode (cheader_filename = "illuminate.h")]
				public interface IAppCodeBuildable {
					public abstract string build_app_code (Kangaroo.Model.Meta.MetaTable table);
				}
				[CCode (cheader_filename = "illuminate.h")]
				public interface ISqlCodeBuildable {
					public abstract string build_delete (Kangaroo.Model.Meta.MetaTable table);
					public abstract string build_insert (Kangaroo.Model.Meta.MetaTable table);
					public abstract string build_select (Kangaroo.Model.Meta.MetaTable table);
					public abstract string build_table (Kangaroo.Model.Meta.MetaTable table);
					public abstract string build_update (Kangaroo.Model.Meta.MetaTable table);
				}
			}
			namespace Container {
				[CCode (cheader_filename = "illuminate.h")]
				public interface IContainer : GLib.Object {
					public abstract bool has (GLib.Type type);
					public abstract void register_factory (GLib.Type key_type, Kangaroo.Illuminate.Contracts.Container.ContainerFactoryFunc factory);
					public abstract void register_instance (GLib.Type key_type, GLib.Object instance);
					public abstract void register_type (GLib.Type key_type, GLib.Type value_type);
					public abstract GLib.Object? resolve (GLib.Type type);
				}
				[CCode (cheader_filename = "illuminate.h", has_target = false)]
				public delegate GLib.Object ContainerFactoryFunc (Kangaroo.Illuminate.Contracts.Container.IContainer container);
			}
			namespace Crypto {
				[CCode (cheader_filename = "illuminate.h")]
				public interface IAsymmetricCipher : GLib.Object {
					public abstract void decrypt (uint8[] inbuf_cipher, out uint8[] outbuf_plain = null, out int outbuf_length = null) throws GLib.Error;
					public abstract void encrypt (uint8[] inbuf_plain, out uint8[] outbuf_cipher = null, out int outbuf_length = null) throws GLib.Error;
					public abstract void initialize () throws GLib.Error;
					public abstract void load_private_key (string private_key_file) throws GLib.Error;
					public abstract void load_public_key (string public_key_file) throws GLib.Error;
					public abstract void save_key (out uint8[] public_key = null, out uint8[] private_key = null) throws GLib.Error;
					public abstract void save_key_file (string public_key, string private_key) throws GLib.Error;
				}
				[CCode (cheader_filename = "illuminate.h")]
				public interface ISymmetricCipher : GLib.Object {
					public abstract void decrypt (uint8[] inbuf_cipher, out uint8[] outbuf_plain = null, out int outbuf_length = null) throws GLib.Error;
					public abstract void encrypt (uint8[] inbuf_plain, out uint8[] outbuf_cipher = null, out int outbuf_length = null) throws GLib.Error;
					public abstract void initialize (string key, string salt, string algorithm = "aes_256_cbc") throws GLib.Error;
				}
			}
			namespace Data {
				[CCode (cheader_filename = "illuminate.h")]
				public interface IDocument : GLib.Object {
					public abstract void produce (Kangaroo.Model.Meta.MetaDatabase database, string filename, Kangaroo.Illuminate.Contracts.Data.Configuration cfg, Kangaroo.Illuminate.Contracts.Data.ProgressCallback? callback = null) throws GLib.Error;
				}
				[CCode (cheader_filename = "illuminate.h")]
				public interface IExporter : GLib.Object {
					public const string ACTION_APPEND;
					public const string ACTION_DELETE;
					public const string ACTION_INSERT;
					public const string ACTION_MERGE;
					public const string ACTION_REPLACE;
					public const string ACTION_UPDATE;
					public const string ACTION_VALUES;
					public const string ACTION_WHERE;
					public const string DEFAULT_ENCODING;
					public const int DEFAULT_ROWLIMIT;
					public const string OPTION_ACTION;
					public const string OPTION_COLUMNS;
					public const string OPTION_CONTINUE;
					public const string OPTION_DATABASE;
					public const string OPTION_ENCODING;
					public const string OPTION_FILEPATH;
					public const string OPTION_FORMAT;
					public const string OPTION_INCONVERTIBLE;
					public const string OPTION_PRIMARIES;
					public const string OPTION_SCHEMA;
					public const string OPTION_SOURCE;
					public const string OPTION_STORAGE;
					public const string OPTION_SUMMARY;
					public const string OPTION_TABLELIST;
					public const string OPTION_TABLENAME;
					public const string OPTION_TABLESMAP;
					public const string OPTION_TRANSPOSE;
					public abstract int export_to_file (Kangaroo.Model.Data.TableModel model, string filename, Kangaroo.Illuminate.Contracts.Data.ExtractCallback? callback = null) throws GLib.Error;
					public abstract int export_to_text (Kangaroo.Model.Data.TableModel model, ref string buffer, Kangaroo.Illuminate.Contracts.Data.ExtractCallback? callback = null) throws GLib.Error;
					public abstract bool continue_on_error { get; set; }
					public abstract string file_extention { get; }
					public abstract Gee.HashMap<string,string> options { get; }
				}
				[CCode (cheader_filename = "illuminate.h")]
				public interface IImporter : GLib.Object {
					public abstract async ssize_t import_from_file (Kangaroo.Illuminate.Contracts.Database.IConnection connection, Kangaroo.Model.Meta.MetaTable table, Kangaroo.Illuminate.Contracts.Data.ExtractCallback? callback = null) throws GLib.Error;
					public abstract async ssize_t import_from_text (string textbuffer, Kangaroo.Illuminate.Contracts.Database.IConnection connection, Kangaroo.Model.Meta.MetaTable table, Kangaroo.Illuminate.Contracts.Data.ExtractCallback? callback = null) throws GLib.Error;
					public abstract Kangaroo.Model.Data.TableModel load_from_file (int limit, Kangaroo.Illuminate.Contracts.Data.ExtractCallback? callback = null) throws GLib.Error;
					public abstract Kangaroo.Model.Data.TableModel load_from_text (string textbuffer, Kangaroo.Illuminate.Contracts.Data.ExtractCallback? callback = null) throws GLib.Error;
				}
				[CCode (cheader_filename = "illuminate.h")]
				public struct Configuration {
					public string title;
					public string version;
					public string description;
					public string organization;
					public string website;
				}
				[CCode (cheader_filename = "illuminate.h")]
				public delegate void ExtractCallback (ssize_t total, ssize_t current, string line_text);
				[CCode (cheader_filename = "illuminate.h")]
				public delegate void ProgressCallback (int total, int current);
			}
			namespace Database {
				[CCode (cheader_filename = "illuminate.h")]
				public interface IAdaptable : GLib.Object {
					public const string DATA_FILLED;
					public abstract void fill_data_set (Kangaroo.Model.Data.DataSetModel dataset) throws GLib.Error;
					public abstract void fill_data_table (Kangaroo.Model.Data.TableModel table) throws GLib.Error;
					public abstract void fill_meta_object (Kangaroo.Model.Meta.MetaObject meta_object, bool with_deep = false, bool with_additional = true) throws GLib.Error;
					public abstract void load_privileges (Gee.HashMap<string,string> matrix, string[] filters = new string[0] { }) throws GLib.Error;
				}
				[CCode (cheader_filename = "illuminate.h")]
				public interface IBuildable : GLib.Object {
					public abstract string build_caller (Kangaroo.Model.Meta.MetaRoutine function);
					public abstract string build_create (Kangaroo.Model.Meta.MetaObject meta_object, bool native_first = true);
					public abstract string build_delete (Kangaroo.Model.Meta.MetaObject meta_object);
					public abstract string build_patch (Kangaroo.Model.Meta.MetaObject meta_object, bool native_first = true);
					public abstract string build_with_array (string schema, string table, string[] columns, string[] values, Kangaroo.Illuminate.Contracts.Database.SqlAction action = SqlAction.INSERT, string[] where_columns = new string[0] { }, string[] where_values = new string[0] { });
					public abstract string build_with_dataset (Kangaroo.Model.Data.DataSetModel dataset, Kangaroo.Illuminate.Contracts.Database.SqlAction action = SqlAction.INSERT);
					public abstract string build_with_model (Kangaroo.Model.Data.TableModel model, Kangaroo.Illuminate.Contracts.Database.SqlAction action = SqlAction.INSERT);
					public abstract string build_with_row (Kangaroo.Model.Data.TableModel model, Kangaroo.Model.Data.RowModel row, Kangaroo.Illuminate.Contracts.Database.SqlAction action = SqlAction.INSERT);
					public abstract string patch_with_dataset (Kangaroo.Model.Data.DataSetModel dataset);
					public abstract string patch_with_model (Kangaroo.Model.Data.TableModel model);
					public abstract string quote_id_full (string fullname, string separator = ".", string replacement = "*");
					public abstract string quote_id_names (string[] names, string separator = ".");
					public abstract string quote_id_object (Kangaroo.Model.Meta.MetaObject object, bool include_database = false);
					public abstract string quote_value (Kangaroo.Model.Data.DataType column_type, string raw_value);
				}
				[CCode (cheader_filename = "illuminate.h")]
				public interface ICachable : GLib.Object {
					public abstract void append (string key, string value);
					public abstract void clear ();
					public abstract string? lookup (string key);
				}
				[CCode (cheader_filename = "illuminate.h")]
				public interface IConnection : GLib.Object {
					public abstract Kangaroo.Illuminate.Contracts.Database.IAdaptable adapter ();
					public abstract Kangaroo.Illuminate.Contracts.Database.IBuildable builder ();
					public abstract Kangaroo.Illuminate.Contracts.Database.ICachable cache ();
					public abstract Kangaroo.Illuminate.Contracts.Database.IConnection? clone () throws GLib.Error;
					public abstract void close () throws GLib.Error;
					public abstract void commit () throws GLib.Error;
					public abstract GLib.Object[] console (string schema, string command, out string? prefix = null) throws GLib.Error;
					public abstract GLib.Object[] execute (string statements, bool in_thread = false) throws GLib.Error;
					public abstract Kangaroo.Model.Data.TableModel execute_as_model (string sql, bool in_thread = false) throws GLib.Error;
					public abstract async Kangaroo.Model.Data.TableModel execute_as_model_async (string sql) throws GLib.Error;
					public abstract Kangaroo.Model.Data.ValueObject execute_as_scalar (string sql, bool in_thread = false) throws GLib.Error;
					public abstract async Kangaroo.Model.Data.ValueObject execute_as_scalar_async (string sql) throws GLib.Error;
					public abstract async GLib.Object[] execute_async (string statements) throws GLib.Error;
					public abstract ssize_t execute_no_query (string sql, bool in_thread = false) throws GLib.Error;
					public abstract async ssize_t execute_no_query_async (string sql) throws GLib.Error;
					public abstract Kangaroo.Providers.Contracts.IDataReader execute_reader (string statement) throws GLib.Error;
					public abstract Kangaroo.Illuminate.Contracts.Database.IExplorable explorer ();
					public abstract Kangaroo.Illuminate.Contracts.Database.IFormattable formatter ();
					public abstract Kangaroo.Illuminate.Contracts.Database.IInspectable inspector ();
					public abstract void open (Kangaroo.Model.Setting.Server server, Kangaroo.Model.Setting.NetworkSetting? network = null) throws GLib.Error;
					public abstract async void open_async (Kangaroo.Model.Setting.Server server, Kangaroo.Model.Setting.NetworkSetting? network = null) throws GLib.Error;
					public abstract void reopen () throws GLib.Error;
					public abstract async void reopen_async () throws GLib.Error;
					public abstract void rollback () throws GLib.Error;
					public abstract Kangaroo.Illuminate.Contracts.Database.IStatement statement ();
					public abstract bool transaction () throws GLib.Error;
					public abstract uint major_version { get; }
					public abstract uint minor_version { get; }
					public abstract Kangaroo.Providers.Contracts.IProvider provider { get; }
					public abstract Kangaroo.Model.Setting.Server server { get; }
					public abstract Kangaroo.Illuminate.Contracts.Database.DBStatus status { get; set; }
					public abstract string version { get; }
					public signal void closed (Kangaroo.Illuminate.Contracts.Database.IConnection conn);
					public signal void opened (Kangaroo.Illuminate.Contracts.Database.IConnection conn);
				}
				[CCode (cheader_filename = "illuminate.h")]
				public interface IExplorable : GLib.Object {
					public const string DATA_CURSOR;
					public virtual void drop_object (Kangaroo.Model.Meta.DBObject type, string database, string schema, string object) throws GLib.Error;
					public abstract void exec_command (Kangaroo.Model.Meta.DBObject type, string database, string schema, string object, string extra_data, string command, Kangaroo.Model.Data.RowModel? row_model = null) throws GLib.Error;
					public abstract Kangaroo.Model.Data.TableModel load_objects (Kangaroo.Model.Meta.DBObject type, string database, string schema, string extra_data = "", int records_max = -1, Kangaroo.Model.Data.TableModel? live_model = null) throws GLib.Error;
				}
				[CCode (cheader_filename = "illuminate.h")]
				public interface IFormattable : GLib.Object {
					public const string OPTION_FORMAT_POSITION;
					public const string OPTION_INDENT_TEXT;
					public const string OPTION_KEYWORDS;
					public const string OPTION_LINE_BREAK;
					public const string OPTION_LINE_START;
					public const string OPTION_PUNCTUATION;
					public abstract string beautify (string statements);
					public abstract string minify (string statements);
					public abstract void option (string name, string value);
				}
				[CCode (cheader_filename = "illuminate.h")]
				public interface IInspectable : GLib.Object {
					public abstract Kangaroo.Model.Data.DataType get_data_type (string native_type, bool is_unsigned = false, int size = 0, int scale = 0);
					public abstract string get_sql_type (Kangaroo.Model.Data.DataType data_type);
					public abstract string get_type_default (string data_type);
					public abstract string[] support (Kangaroo.Illuminate.Contracts.Database.DbMetaType type);
				}
				[CCode (cheader_filename = "illuminate.h")]
				public interface IStatement : GLib.Object {
					public const string BUILDER_EXPR_SEPARATOR;
					public abstract string active_database ();
					public abstract string build_analyze (string statement, string format = "");
					public abstract string build_connection_string (Kangaroo.Model.Setting.Server server);
					public abstract string build_explain (string statement, string format = "");
					public abstract string build_sql_view (string user_schema, string view_name, string statements);
					public abstract string call_function (string database, string user_schema, string function, string parameters);
					public abstract string call_procedure (string database, string user_schema, string procedure, string parameters);
					public abstract string change_database (string database);
					public abstract string commit (string name);
					public abstract string drop_object (Kangaroo.Model.Meta.DBObject object_type, string database, string user_schema, string object_name, string object_target = "");
					public abstract string empty_table (string database, string user_schema, string object_name);
					public abstract string flush_privileges ();
					public abstract string grant_role_rights (string database, string user_schema, string username, string object, string rights);
					public abstract string grant_user_rights (string database, string user_schema, string username, string object, string rights);
					public abstract string parse_expression (Kangaroo.Model.Data.DataType data_type, string expression);
					public abstract string parse_joinable (string joinable, string expression);
					public abstract string rename_object (Kangaroo.Model.Meta.DBObject object_type, string database, string user_schema, string old_name, string new_name);
					public abstract string revoke_role_rights (string database, string user_schema, string username, string object, string rights);
					public abstract string revoke_user_rights (string database, string user_schema, string username, string object, string rights);
					public abstract string rollback (string name);
					public abstract string show_checks (string database, string user_schema = "", out int name_index = null);
					public abstract string show_content (string database, string user_schema, string table, string columns = "*", string where = "", string order = "", int64 offset = 0, int limit = -1);
					public abstract string show_databases (out int name_index = null);
					public abstract string show_effected (string database, string user_schema, string table, string where = "");
					public abstract string show_excludes (string database, string user_schema = "", out int name_index = null);
					public abstract string show_foreigns (string database, string user_schema = "", out int name_index = null);
					public abstract string show_functions (string database, string user_schema = "", out int name_index = null);
					public abstract string show_indexes (string database, string user_schema = "", out int name_index = null);
					public abstract string show_privileges (out int index_privilege, out int index_context);
					public abstract string show_procedures (string database, string user_schema = "", out int name_index = null);
					public abstract string show_role_detail (string database, string user_schema, string rolename);
					public abstract string show_role_rights (string database, string user_schema, string rolename);
					public abstract string show_roles (string database, string user_schema = "", out int name_index = null);
					public abstract string show_rules (string database, string user_schema = "", out int name_index = null);
					public abstract string show_source (Kangaroo.Model.Meta.DBObject object_type, string database, string user_schema, string name, out int stmt_index = null);
					public abstract string show_structure (string database, string user_schema, string table, out int name_index = null);
					public abstract string show_table_schemas (string database, out int name_index = null);
					public abstract string show_table_spaces (string database, out int name_index = null);
					public abstract string show_tables (string database, string user_schema = "", out int name_index = null);
					public abstract string show_triggers (string database, string user_schema = "", out int name_index = null);
					public abstract string show_uniques (string database, string user_schema = "", out int name_index = null);
					public abstract string show_user_detail (string database, string user_schema, string username);
					public abstract string show_user_rights (string database, string user_schema, string username);
					public abstract string show_users (string database, string user_schema = "", out int name_index = null);
					public abstract string show_views (string database, string user_schema = "", out int name_index = null);
					public abstract string transaction (string name);
				}
				[CCode (cheader_filename = "illuminate.h")]
				public enum DBStatus {
					Unknown,
					Closed,
					Opened,
					Failed
				}
				[CCode (cheader_filename = "illuminate.h")]
				public enum DbMetaType {
					NONE,
					ACCESS_TYPE,
					ALTERNATE,
					AUTHENTICATION,
					AUTHENTICATION_LOGIN,
					CACHE,
					CASE_LEVEL,
					CASE_FIRST,
					CHARSET,
					COLLATION,
					COLUMN_DEFAULT,
					COLUMN_NAME,
					COLUMN_TYPE,
					COLUMN_VISIBILITY,
					COMMIT_ACTION,
					COMPRESSION,
					COMPRESSION_COLUMN,
					COMPRESSION_DATA,
					COMPRESSION_ROW,
					COMPRESSION_XML,
					CONSTRAINT_NAME,
					CONSTRAINT_COLUMN,
					CREDENTIAL,
					CURSOR_TYPE,
					[Version (deprecated_since = "4.1")]
					DATA_TYPE,
					DATA_TYPE_UNIT,
					DATABASE_STATE,
					DATABASE_FILE_TYPE,
					DATASET_STATEMENT,
					DEFERRED_ACTION,
					EDITIONABLE,
					EDITION_ACTION,
					ENDPOINT,
					EXPLORABLE,
					FOREIGNKEY_ACTION,
					FOREIGNKEY_MATCH,
					GENERATE_ACTION,
					GENERATE_STORAGE,
					GRANULARITY,
					INDEX_ALGORITHM,
					INDEX_BUFFERING,
					INDEX_FAST_UPDATE,
					INDEX_KEY_BLOCK_SIZE,
					INDEX_LOCK,
					INDEX_METHOD,
					INDEX_PARSER,
					INDEX_TYPE,
					INDEX_USING,
					INSERT_METHOD,
					USER_LANGUAGE,
					LOCK_ESCALATION,
					LOGGING,
					LOGIN_ASYMMETRIC_KEY,
					LOGIN_CERTIFICATE,
					LOGIN_NAME,
					ONCONFLICT,
					OPERATOR,
					OPERATOR_CLASS,
					ORDER_NORMAL,
					ORDER_NULLS,
					PARAMETERIZATION,
					PERMISSION,
					PLUGIN_AUTH,
					POLICY_DIGEST,
					READ_CONCERN,
					RECOVERY,
					ROLE_APPLICATION,
					ROLE_DATABASE,
					ROLE_OWNER,
					ROLE_SERVER,
					ROUTINE_ALL,
					ROUTINE_DIRECTION,
					ROUTINE_FUNCTION,
					ROUTINE_LANGUAGE,
					ROUTINE_DATA_ACCESS,
					ROUTINE_NULL_RULE,
					ROUTINE_PARALLEL,
					ROUTINE_PROCEDURE,
					ROUTINE_RETURN_TYPE,
					ROUTINE_SECURITY,
					ROUTINE_TYPE,
					ROUTINE_PIPE_TYPE,
					ROUTINE_VOLATILITY,
					ROW_FORMAT,
					ROW_ACTION,
					RULE_ACTION,
					RULE_APPLY,
					RULE_EVENT,
					SERVERS,
					SYNC_TRANSFER,
					SYNC_STRUCTURE,
					SYNC_DATA,
					STRENGTH,
					TABLE_COMMIT,
					TABLE_ENGINE,
					TABLE_INHERITS,
					TABLE_FLAG,
					TABLE_NAME,
					TABLE_NAMESPACE,
					TABLE_OWNER,
					TABLE_PARTITION,
					TABLE_SCHEMA,
					TABLE_SHARE,
					TABLE_STORAGE,
					TABLE_TABLESPACE,
					TABLE_TEMPLATE,
					TEMPLATE_FUNCTION,
					TEMPLATE_PROCEDURE,
					TRIGGER_DEFERRABLE,
					TRIGGER_DEFERRED,
					TRIGGER_DEFINITION_TYPE,
					TRIGGER_EXECUTOR,
					TRIGGER_FIRE_EVENT,
					TRIGGER_FIRE_TIME,
					TRIGGER_FIRE_TIME_TABLE,
					TRIGGER_FIRE_TIME_VIEW,
					TRIGGER_FOR_EACH,
					TRIGGER_ORDER,
					TRIGGER_ROUTINE,
					TRIGGER_TEMPLATE,
					TRIGGER_TYPE,
					TYPE_STANDARD,
					TYPE_USER_DEFINED,
					USER,
					USER_PROFILE,
					USER_WITH_ROLE,
					VALIDATION_ACTION,
					VALIDATION_LEVEL,
					VALIDATION_TYPE,
					VARIABLES,
					VERIFY_TYPE,
					VERSION_METHOD,
					VERSION_POSITION,
					VIRTUAL_TYPE,
					VIEW_ALGORITHM,
					VIEW_BUILD_PRECISION,
					VIEW_BUILD_TYPE,
					VIEW_SECURITY,
					VIEW_CHECK_OPTION,
					VIEW_REFRESH_METHOD,
					VIEW_REFRESH_FIRE,
					VIEW_REFRESH_TYPE,
					VIEW_REFRESH_CONSTANT,
					YESNO_DEFAULT
				}
				[CCode (cheader_filename = "illuminate.h")]
				public enum SqlAction {
					INSERT,
					UPDATE,
					DELETE,
					SCHEMA,
					FEATURE;
					public string to_string ();
				}
			}
			namespace Log {
				[CCode (cheader_filename = "illuminate.h")]
				public interface IFormatter : GLib.Object {
					public abstract string format (Kangaroo.Illuminate.Contracts.Log.LogLevel level, string server, string name, string format);
				}
				[CCode (cheader_filename = "illuminate.h")]
				public interface ILogHandler : GLib.Object {
					public abstract void close ();
					public abstract void publish (Kangaroo.Illuminate.Contracts.Log.LogLevel level, string server, string name, string format, va_list args);
					public abstract string recent (int64 length = -1);
					public abstract Kangaroo.Illuminate.Contracts.Log.IFormatter formatter { get; set; }
					public abstract Kangaroo.Illuminate.Contracts.Log.LogLevel threshold { get; set; }
				}
				[CCode (cheader_filename = "illuminate.h")]
				public interface ILogManager : GLib.Object {
					public abstract void close (string uuid);
					public abstract void initialize (string log_default, Kangaroo.Illuminate.Contracts.Log.LogLevel level_filter, string log_file_dir, int64 file_size_max);
					public abstract Kangaroo.Illuminate.Contracts.Log.ILogger open (string uuid);
					public abstract void shutdown ();
					public abstract Kangaroo.Illuminate.Contracts.Log.ILogger main { get; }
				}
				[CCode (cheader_filename = "illuminate.h")]
				public interface ILogger : GLib.Object {
					public abstract void append_handler (Kangaroo.Illuminate.Contracts.Log.ILogHandler handler);
					public abstract void close ();
					public abstract void critical (string t_server, string t_name, string format, va_list args);
					public abstract void debug (string t_server, string t_name, string format, va_list args);
					public abstract void delete_handler (Kangaroo.Illuminate.Contracts.Log.ILogHandler handler);
					public abstract void error (string t_server, string t_name, string format, va_list args);
					public abstract Gee.HashSet<Kangaroo.Illuminate.Contracts.Log.ILogHandler> get_handlers ();
					public abstract void info (string t_server, string t_name, string format, va_list args);
					public abstract void initialize (string t_server, string t_name);
					public abstract void message (string t_server, string t_name, string format, va_list args);
					public abstract string recent (int64 length = -1);
					public abstract void remove_handler_all ();
					public abstract void warning (string t_server, string t_name, string format, va_list args);
					public abstract string name { get; }
					public abstract string server { get; }
					public abstract string uuid { get; }
				}
				[CCode (cheader_filename = "illuminate.h")]
				public enum LogLevel {
					RISKY,
					PLAIN,
					DEBUG;
					public string to_string ();
					public string to_number ();
					public string to_color ();
				}
			}
			namespace Serialization {
				[CCode (cheader_filename = "illuminate.h")]
				public interface IJsonSerializer : GLib.Object {
					public virtual void deserialize (Json.Object json_object, GLib.Object object);
					public virtual void serialize (Json.Builder builder, GLib.Object object);
				}
			}
			namespace Storage {
				[CCode (cheader_filename = "illuminate.h")]
				public interface IStorable : GLib.Object {
					public abstract bool load (string path, void* user_object);
					public abstract bool save (string path, string user_data);
				}
			}
			[CCode (cheader_filename = "illuminate.h")]
			public class ThreadProgress {
				public uint64 errors;
				public bool finished;
				public Gee.ArrayQueue<string> messages;
				public uint64 processed;
				public GLib.TimeSpan time;
				public uint64 total;
				public ThreadProgress ();
			}
			[CCode (cheader_filename = "illuminate.h")]
			public interface IClonable : GLib.Object {
				public virtual GLib.Object clone ();
			}
		}
		namespace Exceptions {
			[CCode (cheader_filename = "illuminate.h")]
			public errordomain SqlError {
				APP_ERROR_START,
				CRYPTOGRAPHY,
				MYSQL_ERROR_START,
				POSTGRESQL_ERROR_START,
				SQLITE_ERROR_START,
				UNKNOWN,
				ERROR,
				INTERNAL,
				ACCESS_DENIED,
				ABORTED,
				BUSY,
				LOCKED,
				NO_MEMORY,
				READ_ONLY,
				INTERRUPTED,
				IO,
				CORRUPT,
				NOT_FOUND,
				FULL,
				CAN_NOT_OPEN,
				PROTOCOL,
				EMPTY,
				SCHEMA,
				TOO_BIG,
				CONSTRAINT,
				MISMATCH,
				MISUSE,
				NOLFS,
				AUTH,
				FORMAT,
				RANGE,
				NOTADB,
				DATA_TYPE,
				THREAD,
				TRANSACTION,
				FEATURE_NOT_SUPPORTED,
				NO_SQL,
				MISSING_PARAMETER
			}
		}
		namespace Foundation {
			[CCode (cheader_filename = "illuminate.h")]
			public class Container : GLib.Object, Kangaroo.Illuminate.Contracts.Container.IContainer {
				public Container ();
			}
			[CCode (cheader_filename = "illuminate.h")]
			public class LoggingService {
				public LoggingService ();
				public static void critical (string? uuid, string format, ...);
				public static void debug (string? uuid, string format, ...);
				public static void error (string? uuid, string format, ...);
				public static void info (string? uuid, string format, ...);
				public static void initialize (string uuid_default, Kangaroo.Illuminate.Contracts.Log.LogLevel level_filter, string log_file_dir, int64 file_size_max);
				public static void message (string? uuid, string format, ...);
				public static void shutdown ();
				public static void warning (string? uuid, string format, ...);
				public static Kangaroo.Illuminate.Contracts.Log.ILogManager manager { get; }
			}
			[CCode (cheader_filename = "illuminate.h")]
			public class Services : GLib.Object {
				public Services ();
				public static T @get<T> ();
				public static void initialize ();
				public static void register_instance (GLib.Type key_type, GLib.Object instance);
				public static void register_type (GLib.Type key_type, GLib.Type value_type);
			}
		}
		namespace Helpers {
			[CCode (cheader_filename = "illuminate.h")]
			public class ConvertHelper {
				public ConvertHelper ();
				public static async uint8[] from (uint8[] data, string format);
				public static async uint8[] from_gzip (uint8[] data) throws GLib.Error;
				public static async uint8[] from_zlib (uint8[] data) throws GLib.Error;
				public static async uint8[] to (uint8[] data, string format);
				public static async uint8[] to_gzip (uint8[] data) throws GLib.Error;
				public static async uint8[] to_zlib (uint8[] data) throws GLib.Error;
			}
			[CCode (cheader_filename = "illuminate.h")]
			public class DatabaseHelper {
				public DatabaseHelper ();
				public static string build_sql_delete (string schema, string table, string[] columns, string[] values);
				public static string build_sql_insert (string schema, string table, string[] columns, string[] values);
				public static string build_sql_update (string schema, string table, string[] update_columns, string[] update_values, string[] where_columns, string[] where_values);
				public static double convert_with_unit (uint64 data_size, string unit_old = "B", string unit_new = "B");
				public static string format_object_name (string schema, string table);
				public static string format_size (uint64 data_size);
				public static string format_sql_value (Kangaroo.Model.Data.DataType data_type, Kangaroo.Model.Data.ValueObject data_value);
				public static string make_fullname_mysql (string username);
				public static double match_unit_max (uint64 data_size, string size_unit = "B", out string unit_max = null);
				public static string summary (Kangaroo.Model.Data.ValueBinary value, string null_value = Kangaroo.Model.Data.ValueObject.NULL_LABEL);
				public static bool update_schema_with_model (Kangaroo.Model.Meta.MetaTable table, Kangaroo.Model.Data.TableModel model);
			}
			[CCode (cheader_filename = "illuminate.h")]
			public class DateTimeHelper {
				public DateTimeHelper ();
				public static string datetime_as_compact ();
				public static string datetime_as_iso8601 ();
				public static string datetime_as_normal ();
				public static int64 datetime_as_seconds (string ttl_datetime);
				public static string datetime_as_string (string format = "%Y-%m-%d %H:%M:%S");
				public static string datetime_as_string_ms (string format = "%Y-%m-%d %H:%M:%S", string ms_format = "%03lli");
				public static GLib.DateTime datetime_from_seconds (int64 ttl_value);
				public static string datetime_with_ms_compact ();
				public static string datetime_with_ms_iso8601 ();
				public static string datetime_with_ms_normal ();
				public static string format_time_span (GLib.TimeSpan time_span);
				public static string format_time_span_micro (GLib.TimeSpan time_span);
				public static string format_time_span_unit (GLib.TimeSpan time_span);
			}
			[CCode (cheader_filename = "illuminate.h")]
			public class EncodingHelper {
				public string detect_buffer (uint8[] buffer);
				public string detect_file (string filename);
				public string detect_stream (GLib.InputStream stream);
				public static Kangaroo.Illuminate.Helpers.EncodingHelper singleton { get; }
			}
			[CCode (cheader_filename = "illuminate.h")]
			public class FileTypeHelper {
				public string guess_mime_type_with_bytes (uint8[] buffer, string mime_type_default = "unknown/unknown");
				public string guess_mime_type_with_file (string filename, string mime_type_default = "unknown/unknown");
				public static Kangaroo.Illuminate.Helpers.FileTypeHelper singleton { get; }
			}
			[CCode (cheader_filename = "illuminate.h")]
			public class LocationHelper {
				public const double EARTH_R;
				public const double MAXEXTENT;
				public const double OBLATENESS;
				public const double PI;
				public const double X_PI;
				public LocationHelper ();
				public static double[] bd09_to_gcj02 (double bd_lng, double bd_lat);
				public static double[] bd09_to_wgs84 (double lng, double lat);
				public static void delta (double lng, double lat, out double dLng, out double dLat);
				public static double distance (double lngA, double latA, double lngB, double latB);
				public static double[] espg3857_to_wgs84 (double lng, double lat);
				public static double fabs (double x);
				public static double[] gcj02_to_bd09 (double lng, double lat);
				public static double[] gcj02_to_wgs84 (double lng, double lat);
				public static bool out_of_china (double lng, double lat);
				public static double[] transform (double lng, double lat);
				public static double transform_latitude (double lng, double lat);
				public static double transform_longitude (double lng, double lat);
				public static double[] wgs84_to_bd09 (double lng, double lat);
				public static double[] wgs84_to_epsg3857 (double lng, double lat);
				public static double[] wgs84_to_gcj02 (double lng, double lat);
			}
			[CCode (cheader_filename = "illuminate.h")]
			public class MongoDBHelper {
				public MongoDBHelper ();
				public static Bson.Bson build_command_find (string collection, string columns = "", string filters = "", string sorters = "");
				public static Kangaroo.Model.Data.ValueObject? fill_value (Bson.Bson reply, bool is_array = false, Kangaroo.Model.Data.ValueObject? last_object = null) throws GLib.Error;
				public static string format_command (Bson.Bson command, bool human_readable = true);
				public static string[] load_databases (Kangaroo.Illuminate.Contracts.Database.IConnection connection);
				public static void load_roles (Kangaroo.Illuminate.Contracts.Database.IConnection connection, out string builtins, out string customs);
				public static void load_users (Kangaroo.Illuminate.Contracts.Database.IConnection connection, out string users);
				public static Kangaroo.Model.Data.ValueObject? read_value (Bson.BsonIter bson_iter) throws GLib.Error;
			}
			[CCode (cheader_filename = "illuminate.h")]
			public class PasswordHelper {
				public PasswordHelper ();
				public static void decrypt_password (Kangaroo.Model.Setting.Server server);
				public static void encrypt_password (Kangaroo.Model.Setting.Server server);
				public static string generate_password (int length);
			}
			[CCode (cheader_filename = "illuminate.h")]
			public class StringHelper {
				public StringHelper ();
				public static Gee.HashMap<string,string> arraify_data (string connection, string delimiter = ";");
				public static bool contains_array (string text, string[] needles, bool case_sensitive = true);
				public static void diff_array (string[] array_old, string[] array_new, out string[] array_common, out string[] array_delete, out string[] array_create);
				public static string format_json (string text, int indent = 4, char indent_char = ' ');
				public static string guess_line_ending (string text);
				public static int index_with_array (string text, string[] needles, bool case_sensitive = true, int default_index = -1);
				public static bool prefix_with_array (string content, string[] needles, bool case_sensitive = true);
				public static string proper_case (string str);
				public static string replace_array (string plain, string[] old_texts, string[] new_texts);
				public static string replace_chars (string text, string chars, string replacement);
				public static int search_array (string[] arr_words, string needle, bool case_sensitive = true, int default_index = -1);
				public static int search_array_prefix (string[] arr_words, string needle, bool case_sensitive = true, int default_index = -1);
				public static int search_array_prefix_count (string[] arr_words, string needle, bool case_sensitive = true);
				public static int search_array_suffix (string[] arr_words, string needle, bool case_sensitive = true, int default_index = -1);
				public static int search_array_suffix_count (string[] arr_words, string needle, bool case_sensitive = true);
				public static string stringify_data (Gee.HashMap<string,string> data, string delimiter = ";");
				public static bool suffix_with_array (string content, string[] needles, bool case_sensitive = true);
				public static string trim_chars (string text, string chars);
			}
		}
		namespace Supports {
			namespace Crypto {
				[CCode (cheader_filename = "illuminate.h")]
				public class OpenSSLAsymmetricCipher : GLib.Object, Kangaroo.Illuminate.Contracts.Crypto.IAsymmetricCipher {
					public OpenSSLAsymmetricCipher ();
					public void print_private ();
					public void print_public ();
					public void sign (uint8[] data, out uint8[] signature = null) throws GLib.Error;
				}
				[CCode (cheader_filename = "illuminate.h")]
				public class OpenSSLSymmetricCipher : GLib.Object, Kangaroo.Illuminate.Contracts.Crypto.ISymmetricCipher {
					public OpenSSLSymmetricCipher ();
				}
			}
			namespace Data {
				namespace Documents {
					[CCode (cheader_filename = "illuminate.h")]
					public class HtmlDocument : GLib.Object, Kangaroo.Illuminate.Contracts.Data.IDocument {
						public HtmlDocument ();
						protected void make_table_section (GLib.DataOutputStream data_stream, Kangaroo.Model.Meta.MetaTable table) throws GLib.IOError;
						protected void make_view_section (GLib.DataOutputStream data_stream, Kangaroo.Model.Meta.MetaView view) throws GLib.IOError;
					}
					[CCode (cheader_filename = "illuminate.h")]
					public class MarkdownDocument : GLib.Object, Kangaroo.Illuminate.Contracts.Data.IDocument {
						public MarkdownDocument ();
						protected void make_table_section (GLib.DataOutputStream data_stream, Kangaroo.Model.Meta.MetaTable table) throws GLib.IOError;
						protected void make_view_section (GLib.DataOutputStream data_stream, Kangaroo.Model.Meta.MetaView view) throws GLib.IOError;
					}
				}
				namespace Extractors {
					[CCode (cheader_filename = "illuminate.h")]
					public class BaseExtractor : GLib.Object, Kangaroo.Illuminate.Contracts.Data.IExporter {
						protected string m_file_extention;
						protected Gee.HashMap<string,string> m_options;
						public BaseExtractor (string file_ext);
						protected string build_delete_data_sql (Kangaroo.Illuminate.Contracts.Database.IConnection connection, Kangaroo.Model.Meta.MetaTable table, string[] columns, string[] values);
						protected string build_insert_data_sql (Kangaroo.Illuminate.Contracts.Database.IConnection connection, Kangaroo.Model.Meta.MetaTable table, string[] columns, string[] values);
						protected string build_update_data_sql (Kangaroo.Illuminate.Contracts.Database.IConnection connection, Kangaroo.Model.Meta.MetaTable table, string[] columns, string[] values);
						public virtual int export_to_file (Kangaroo.Model.Data.TableModel model, string filename, Kangaroo.Illuminate.Contracts.Data.ExtractCallback? callback = null) throws GLib.Error;
						public virtual int export_to_text (Kangaroo.Model.Data.TableModel model, ref string buffer, Kangaroo.Illuminate.Contracts.Data.ExtractCallback? callback = null) throws GLib.Error;
						protected string format_column_text (Kangaroo.Model.Data.DataType column_type, string data_value);
						protected string format_column_value (Kangaroo.Model.Data.DataType column_type, Kangaroo.Model.Data.ValueObject data_value);
					}
					[CCode (cheader_filename = "illuminate.h")]
					public class CodeExtractor : Kangaroo.Illuminate.Supports.Data.Extractors.BaseExtractor {
						public const string[] LANGUAGES;
						public CodeExtractor ();
						public override int export_to_text (Kangaroo.Model.Data.TableModel model, ref string buffer, Kangaroo.Illuminate.Contracts.Data.ExtractCallback? callback = null) throws GLib.Error;
					}
					[CCode (cheader_filename = "illuminate.h")]
					public class DsvExtractor : Kangaroo.Illuminate.Supports.Data.Extractors.BaseExtractor, Kangaroo.Illuminate.Contracts.Data.IImporter {
						public const string DELIMITER_COLUMN;
						public const string DELIMITER_ROWNEW;
						public const string HAS_HEADER;
						public const string NULL_VALUE;
						public const string QUALIFIER;
						public const string QUOTATION_LIST;
						public const string QUOTATION_TIME;
						public const string QUOTATION_TIME_ALWAYS;
						public const string QUOTATION_TIME_IFNEED;
						public const string ROW_PREFIX;
						public const string ROW_SUFFIX;
						public const string TRIMSPACES;
						public DsvExtractor (string file_extension = "csv");
						public override int export_to_file (Kangaroo.Model.Data.TableModel model, string filename, Kangaroo.Illuminate.Contracts.Data.ExtractCallback? callback = null) throws GLib.Error;
						public override int export_to_text (Kangaroo.Model.Data.TableModel model, ref string buffer, Kangaroo.Illuminate.Contracts.Data.ExtractCallback? callback = null) throws GLib.Error;
					}
					[CCode (cheader_filename = "illuminate.h")]
					public class ExcelExtractor : Kangaroo.Illuminate.Supports.Data.Extractors.BaseExtractor, Kangaroo.Illuminate.Contracts.Data.IImporter {
						public const string NULL_VALUE;
						public const string USE_ATTRIBUTE;
						public ExcelExtractor (string file_extension = "xlsx");
					}
					[CCode (cheader_filename = "illuminate.h")]
					public class HtmlExtractor : Kangaroo.Illuminate.Supports.Data.Extractors.BaseExtractor {
						public HtmlExtractor (string file_extension = "html");
						public override int export_to_text (Kangaroo.Model.Data.TableModel model, ref string buffer, Kangaroo.Illuminate.Contracts.Data.ExtractCallback? callback = null) throws GLib.Error;
					}
					[CCode (cheader_filename = "illuminate.h")]
					public class JsonExtractor : Kangaroo.Illuminate.Supports.Data.Extractors.BaseExtractor, Kangaroo.Illuminate.Contracts.Data.IImporter {
						public JsonExtractor (string file_extension = "json");
						public override int export_to_file (Kangaroo.Model.Data.TableModel model, string filename, Kangaroo.Illuminate.Contracts.Data.ExtractCallback? callback = null) throws GLib.Error;
						public override int export_to_text (Kangaroo.Model.Data.TableModel model, ref string buffer, Kangaroo.Illuminate.Contracts.Data.ExtractCallback? callback = null) throws GLib.Error;
					}
					[CCode (cheader_filename = "illuminate.h")]
					public class MarkdownExtractor : Kangaroo.Illuminate.Supports.Data.Extractors.BaseExtractor {
						public MarkdownExtractor (string file_extension = "md");
						public override int export_to_text (Kangaroo.Model.Data.TableModel model, ref string buffer, Kangaroo.Illuminate.Contracts.Data.ExtractCallback? callback = null) throws GLib.Error;
					}
					[CCode (cheader_filename = "illuminate.h")]
					public class PrettyExtractor : Kangaroo.Illuminate.Supports.Data.Extractors.BaseExtractor {
						public PrettyExtractor (string file_extension = "txt");
						public override int export_to_text (Kangaroo.Model.Data.TableModel model, ref string buffer, Kangaroo.Illuminate.Contracts.Data.ExtractCallback? callback = null) throws GLib.Error;
					}
					[CCode (cheader_filename = "illuminate.h")]
					public class SqlExtractor : Kangaroo.Illuminate.Supports.Data.Extractors.BaseExtractor {
						public SqlExtractor ();
						public override int export_to_text (Kangaroo.Model.Data.TableModel model, ref string buffer, Kangaroo.Illuminate.Contracts.Data.ExtractCallback? callback = null) throws GLib.Error;
						public void initialize (Kangaroo.Illuminate.Contracts.Database.IConnection connection, Kangaroo.Model.Meta.MetaTable meta_table);
					}
					[CCode (cheader_filename = "illuminate.h")]
					public class SqlInsertExtractor : Kangaroo.Illuminate.Supports.Data.Extractors.BaseExtractor {
						public SqlInsertExtractor ();
						public override int export_to_text (Kangaroo.Model.Data.TableModel model, ref string buffer, Kangaroo.Illuminate.Contracts.Data.ExtractCallback? callback = null) throws GLib.Error;
					}
					[CCode (cheader_filename = "illuminate.h")]
					public class SqlUpdateExtractor : Kangaroo.Illuminate.Supports.Data.Extractors.BaseExtractor {
						public SqlUpdateExtractor ();
						public override int export_to_text (Kangaroo.Model.Data.TableModel model, ref string buffer, Kangaroo.Illuminate.Contracts.Data.ExtractCallback? callback = null) throws GLib.Error;
					}
					[CCode (cheader_filename = "illuminate.h")]
					public class XmlExtractor : Kangaroo.Illuminate.Supports.Data.Extractors.BaseExtractor, Kangaroo.Illuminate.Contracts.Data.IImporter {
						public const string NULL_VALUE;
						public const string USE_ATTRIBUTE;
						public XmlExtractor (string file_extension = "xml");
						public override int export_to_file (Kangaroo.Model.Data.TableModel model, string filename, Kangaroo.Illuminate.Contracts.Data.ExtractCallback? callback = null) throws GLib.Error;
						public override int export_to_text (Kangaroo.Model.Data.TableModel model, ref string buffer, Kangaroo.Illuminate.Contracts.Data.ExtractCallback? callback = null) throws GLib.Error;
					}
					[CCode (cheader_filename = "illuminate.h")]
					public class YamlExtractor : Kangaroo.Illuminate.Supports.Data.Extractors.BaseExtractor {
						public YamlExtractor (string file_extension = "yaml");
						public override int export_to_text (Kangaroo.Model.Data.TableModel model, ref string buffer, Kangaroo.Illuminate.Contracts.Data.ExtractCallback? callback = null) throws GLib.Error;
					}
				}
			}
			namespace Database {
				[CCode (cheader_filename = "illuminate.h")]
				public class Adapter : GLib.Object, Kangaroo.Illuminate.Contracts.Database.IAdaptable {
					protected weak Kangaroo.Illuminate.Contracts.Database.IConnection m_connection;
					public Adapter (Kangaroo.Illuminate.Contracts.Database.IConnection connection);
					public virtual void fill_data_set (Kangaroo.Model.Data.DataSetModel dataset) throws GLib.Error;
					public virtual void fill_data_table (Kangaroo.Model.Data.TableModel table) throws GLib.Error;
					public virtual void fill_meta_object (Kangaroo.Model.Meta.MetaObject meta_object, bool with_deep = false, bool with_additional = true) throws GLib.Error;
					public virtual void load_privileges (Gee.HashMap<string,string> matrix, string[] filters = new string[0] { }) throws GLib.Error;
				}
				[CCode (cheader_filename = "illuminate.h")]
				public class ConnectionImpl : GLib.Object, Kangaroo.Illuminate.Contracts.Database.IConnection {
					protected Kangaroo.Providers.Contracts.IProvider m_connection;
					protected Kangaroo.Illuminate.Contracts.Database.IAdaptable m_data_adapter;
					protected Kangaroo.Illuminate.Contracts.Database.ICachable m_data_cache;
					protected Kangaroo.Illuminate.Contracts.Database.IExplorable m_db_explorer;
					protected Kangaroo.Illuminate.Contracts.Database.IInspectable m_db_inspector;
					protected uint m_major_version;
					protected uint m_minor_version;
					protected GLib.Mutex m_mutex;
					protected weak Kangaroo.Model.Setting.NetworkSetting m_server_network;
					protected Kangaroo.Model.Setting.Server m_server_setting;
					protected string m_server_version;
					protected Kangaroo.Illuminate.Contracts.Database.IBuildable m_sql_builder;
					protected Kangaroo.Illuminate.Contracts.Database.IFormattable m_sql_formatter;
					protected Kangaroo.Illuminate.Contracts.Database.IStatement m_sql_statement;
					public ConnectionImpl ();
					public virtual Kangaroo.Illuminate.Contracts.Database.IAdaptable adapter ();
					public virtual Kangaroo.Illuminate.Contracts.Database.IBuildable builder ();
					public virtual Kangaroo.Illuminate.Contracts.Database.ICachable cache ();
					public virtual void close () throws GLib.Error;
					public virtual void commit () throws GLib.Error;
					public virtual GLib.Object[] console (string schema, string command, out string? prefix = null) throws GLib.Error;
					public virtual GLib.Object[] execute (string statements, bool in_thread = false) throws GLib.Error;
					public virtual Kangaroo.Model.Data.TableModel execute_as_model (string sql, bool in_thread = false) throws GLib.Error;
					public virtual async Kangaroo.Model.Data.TableModel execute_as_model_async (string sql) throws GLib.Error;
					public virtual Kangaroo.Model.Data.ValueObject execute_as_scalar (string sql, bool in_thread = false) throws GLib.Error;
					public virtual async Kangaroo.Model.Data.ValueObject execute_as_scalar_async (string sql) throws GLib.Error;
					public virtual async GLib.Object[] execute_async (string statements) throws GLib.Error;
					public virtual ssize_t execute_no_query (string sql, bool in_thread = false) throws GLib.Error;
					public virtual async ssize_t execute_no_query_async (string sql) throws GLib.Error;
					public virtual Kangaroo.Providers.Contracts.IDataReader execute_reader (string sql) throws GLib.Error;
					public virtual Kangaroo.Illuminate.Contracts.Database.IExplorable explorer ();
					public virtual Kangaroo.Illuminate.Contracts.Database.IFormattable formatter ();
					public virtual Kangaroo.Illuminate.Contracts.Database.IInspectable inspector ();
					public virtual void open (Kangaroo.Model.Setting.Server server, Kangaroo.Model.Setting.NetworkSetting? network = null) throws GLib.Error;
					public virtual async void open_async (Kangaroo.Model.Setting.Server server, Kangaroo.Model.Setting.NetworkSetting? network = null) throws GLib.Error;
					protected virtual void open_real (Kangaroo.Model.Setting.Server server) throws GLib.Error;
					public virtual void reopen () throws GLib.Error;
					public virtual async void reopen_async () throws GLib.Error;
					public virtual void rollback () throws GLib.Error;
					public virtual Kangaroo.Illuminate.Contracts.Database.IStatement statement ();
					public virtual bool transaction () throws GLib.Error;
					protected virtual void update_version () throws GLib.Error;
					public virtual uint major_version { get; }
					public virtual uint minor_version { get; }
					public virtual Kangaroo.Model.Setting.Server server { get; }
					public virtual string version { get; }
				}
				[CCode (cheader_filename = "illuminate.h")]
				public class DataCache : GLib.Object, Kangaroo.Illuminate.Contracts.Database.ICachable {
					protected Gee.HashMap<string,string> m_data_cache;
					public DataCache ();
				}
				[CCode (cheader_filename = "illuminate.h")]
				public class Formatter : GLib.Object, Kangaroo.Illuminate.Contracts.Database.IFormattable {
					protected Gee.HashMap<string,string> m_options;
					protected string[] m_shifts;
					protected string m_step;
					public Formatter ();
				}
				[CCode (cheader_filename = "illuminate.h")]
				public class MariaDBAdapter : Kangaroo.Illuminate.Supports.Database.Adapter {
					public MariaDBAdapter (Kangaroo.Illuminate.Contracts.Database.IConnection connection);
					protected virtual void fill_meta_database (Kangaroo.Model.Meta.MetaDatabase database, bool with_deep = false, bool with_additional = true) throws GLib.Error;
					public override void fill_meta_object (Kangaroo.Model.Meta.MetaObject meta_object, bool with_deep = false, bool with_additional = true) throws GLib.Error;
					protected virtual void fill_meta_schema (Kangaroo.Model.Meta.MetaSchema schema, bool with_deep = false, bool with_additional = true) throws GLib.Error;
					protected virtual Kangaroo.Model.Meta.MetaTable fill_schema_table_check (Kangaroo.Model.Meta.MetaTable table) throws GLib.Error;
					protected Kangaroo.Model.Meta.MetaTable fill_schema_table_options (Kangaroo.Model.Meta.MetaTable table) throws GLib.Error;
					public override void load_privileges (Gee.HashMap<string,string> matrix, string[] filters = new string[0] { }) throws GLib.Error;
					protected virtual void load_relation (Kangaroo.Model.Meta.MetaRelation relation) throws GLib.Error;
				}
				[CCode (cheader_filename = "illuminate.h")]
				public class MariaDBAdapterBelowV105 : Kangaroo.Illuminate.Supports.Database.MariaDBAdapter {
					public MariaDBAdapterBelowV105 (Kangaroo.Illuminate.Contracts.Database.IConnection connection);
					protected override void fill_meta_database (Kangaroo.Model.Meta.MetaDatabase database, bool with_deep = false, bool with_additional = true) throws GLib.Error;
				}
				[CCode (cheader_filename = "illuminate.h")]
				public class MariaDBConnection : Kangaroo.Illuminate.Supports.Database.ConnectionImpl {
					public MariaDBConnection ();
					public override Kangaroo.Illuminate.Contracts.Database.IAdaptable adapter ();
					public override Kangaroo.Illuminate.Contracts.Database.IBuildable builder ();
					public override Kangaroo.Illuminate.Contracts.Database.IExplorable explorer ();
					public override Kangaroo.Illuminate.Contracts.Database.IInspectable inspector ();
					public override Kangaroo.Illuminate.Contracts.Database.IStatement statement ();
					protected override void update_version () throws GLib.Error;
				}
				[CCode (cheader_filename = "illuminate.h")]
				public class MariaDBExplorer : GLib.Object, Kangaroo.Illuminate.Contracts.Database.IExplorable {
					public MariaDBExplorer (Kangaroo.Illuminate.Contracts.Database.IConnection conn);
				}
				[CCode (cheader_filename = "illuminate.h")]
				public class MariaDBInspector : GLib.Object, Kangaroo.Illuminate.Contracts.Database.IInspectable {
					public MariaDBInspector (Kangaroo.Illuminate.Contracts.Database.IConnection conn);
				}
				[CCode (cheader_filename = "illuminate.h")]
				public class MariaDBStatement : Kangaroo.Illuminate.Supports.Database.Statement {
					public MariaDBStatement (Kangaroo.Illuminate.Contracts.Database.IConnection connection);
					public override string active_database ();
					public override string build_analyze (string statement, string format = "");
					public override string build_connection_string (Kangaroo.Model.Setting.Server server);
					public override string build_explain (string statement, string format = "");
					public override string call_function (string database, string user_schema, string function, string parameters);
					public override string call_procedure (string database, string user_schema, string procedure, string parameters);
					public override string change_database (string database);
					public override string drop_object (Kangaroo.Model.Meta.DBObject object_type, string database, string user_schema, string object_name, string object_target = "");
					public override string empty_table (string database, string user_schema, string table);
					public override string flush_privileges ();
					public override string grant_role_rights (string database, string user_schema, string rolename, string object, string rights);
					public override string grant_user_rights (string database, string user_schema, string username, string object, string rights);
					public override string parse_expression (Kangaroo.Model.Data.DataType data_type, string expression);
					public override string rename_object (Kangaroo.Model.Meta.DBObject object_type, string database, string user_schema, string old_name, string new_name);
					public override string revoke_role_rights (string database, string user_schema, string rolename, string object, string rights);
					public override string revoke_user_rights (string database, string user_schema, string username, string object, string rights);
					public override string show_checks (string database, string user_schema = "", out int name_index = null);
					public override string show_content (string database, string user_schema, string table, string columns = "*", string where = "", string order = "", int64 offset = 0, int limit = -1);
					public override string show_databases (out int name_index = null);
					public override string show_effected (string database, string user_schema, string table, string where = "");
					public override string show_foreigns (string database, string user_schema = "", out int name_index = null);
					public override string show_functions (string database, string user_schema = "", out int name_index = null);
					public override string show_indexes (string database, string user_schema = "", out int name_index = null);
					public override string show_privileges (out int index_privilege, out int index_context);
					public override string show_procedures (string database, string user_schema = "", out int name_index = null);
					public override string show_role_detail (string database, string user_schema, string rolename);
					public override string show_role_rights (string database, string user_schema, string rolename);
					public override string show_roles (string database, string user_schema = "", out int name_index = null);
					public override string show_source (Kangaroo.Model.Meta.DBObject object_type, string database, string user_schema, string name, out int stmt_index = null);
					public override string show_structure (string database, string user_schema, string table, out int name_index = null);
					public override string show_table_schemas (string database, out int name_index = null);
					public override string show_table_spaces (string database, out int name_index = null);
					public override string show_tables (string database, string user_schema = "", out int name_index = null);
					public override string show_triggers (string database, string user_schema = "", out int name_index = null);
					public override string show_uniques (string database, string user_schema = "", out int name_index = null);
					public override string show_user_detail (string database, string user_schema, string username);
					public override string show_user_rights (string database, string user_schema, string username);
					public override string show_users (string database, string user_schema = "", out int name_index = null);
					public override string show_views (string database, string user_schema = "", out int name_index = null);
				}
				[CCode (cheader_filename = "illuminate.h")]
				public class MongoDBAdapter : Kangaroo.Illuminate.Supports.Database.Adapter {
					protected const string[] TYPE_LIST_CHARACTER;
					public MongoDBAdapter (Kangaroo.Illuminate.Contracts.Database.IConnection connection);
					protected virtual void fill_meta_database (Kangaroo.Model.Meta.MetaDatabase database, bool with_deep = false, bool with_additional = true) throws GLib.Error;
					public override void fill_meta_object (Kangaroo.Model.Meta.MetaObject meta_object, bool with_deep = false, bool with_additional = true) throws GLib.Error;
					protected virtual void fill_meta_role (Kangaroo.Model.Meta.MetaRole meta_role) throws GLib.Error;
					protected virtual void fill_meta_routine (Kangaroo.Model.Meta.MetaRoutine routine) throws GLib.Error;
					protected virtual void fill_meta_schema (Kangaroo.Model.Meta.MetaSchema schema, bool with_deep = false, bool with_additional = true) throws GLib.Error;
					protected virtual void fill_meta_user (Kangaroo.Model.Meta.MetaUser meta_user) throws GLib.Error;
					protected virtual void load_members (Kangaroo.Model.Meta.MetaRole meta_role) throws GLib.Error;
				}
				[CCode (cheader_filename = "illuminate.h")]
				public class MongoDBBuilder : Kangaroo.Illuminate.Supports.Database.SqlBuilder {
					public MongoDBBuilder (Kangaroo.Illuminate.Contracts.Database.IConnection connection);
					public override string build_caller (Kangaroo.Model.Meta.MetaRoutine routine);
					public override string build_create (Kangaroo.Model.Meta.MetaObject meta_object, bool native_first = true);
					public override string build_delete (Kangaroo.Model.Meta.MetaObject meta_object);
					public override string build_patch (Kangaroo.Model.Meta.MetaObject meta_object, bool native_first = true);
					public GLib.Regex regex_parameter { get; }
				}
				[CCode (cheader_filename = "illuminate.h")]
				public class MongoDBConnection : Kangaroo.Illuminate.Supports.Database.ConnectionImpl {
					public MongoDBConnection ();
					public override Kangaroo.Illuminate.Contracts.Database.IAdaptable adapter ();
					public override Kangaroo.Illuminate.Contracts.Database.IBuildable builder ();
					public void delete_file (string database, string gridfs, string file_oid, string file_name) throws GLib.Error;
					public void download_file (string database, string gridfs, string file_oid, string filename) throws GLib.Error;
					public GLib.Bytes download_file_memory (string database, string gridfs, string file_oid, string file_name) throws GLib.Error;
					public void download_file_thread (string database, string gridfs, string file_oid, string filename, Kangaroo.Model.Contracts.Progressor progressor) throws GLib.Error;
					public override GLib.Object[] execute (string statement, bool with_model = false) throws GLib.Error;
					public override Kangaroo.Model.Data.TableModel execute_as_model (string sql, bool in_thread = false) throws GLib.Error;
					public override async Kangaroo.Model.Data.TableModel execute_as_model_async (string sql) throws GLib.Error;
					public override Kangaroo.Model.Data.ValueObject execute_as_scalar (string sql, bool in_thread = false) throws GLib.Error;
					public override async Kangaroo.Model.Data.ValueObject execute_as_scalar_async (string sql) throws GLib.Error;
					public override async GLib.Object[] execute_async (string statement) throws GLib.Error;
					public GLib.Object execute_command (string database, Bson.Bson command, Bson.Bson? option = null, bool with_model = true) throws GLib.Error;
					public Kangaroo.Model.Meta.MetaTable execute_cursor_metadata (string database, string collection, Bson.Bson? option = null) throws GLib.Error;
					public GLib.Object? execute_cursor_object (string database, Bson.Bson command, Bson.Bson? option = null, bool with_model = true) throws GLib.Error;
					public Gee.ArrayList<string> execute_cursor_string (string database, Bson.Bson command, Bson.Bson? option = null) throws GLib.Error;
					public override ssize_t execute_no_query (string statement, bool in_thread = false) throws GLib.Error;
					public override async ssize_t execute_no_query_async (string statement) throws GLib.Error;
					public override Kangaroo.Providers.Contracts.IDataReader execute_reader (string sql) throws GLib.Error;
					public GLib.Object[] execute_statement (string database, string statement) throws GLib.Error;
					public async GLib.Object[] execute_statement_async (string database, string statement) throws GLib.Error;
					public override Kangaroo.Illuminate.Contracts.Database.IExplorable explorer ();
					public override Kangaroo.Illuminate.Contracts.Database.IInspectable inspector ();
					protected override void open_real (Kangaroo.Model.Setting.Server server) throws GLib.Error;
					public override Kangaroo.Illuminate.Contracts.Database.IStatement statement ();
					public void update_file_metadata (string database, string gridfs, string file_oid, string file_name, string prop_name, string prop_value) throws GLib.Error;
					protected override void update_version () throws GLib.Error;
					public void upload_file (string database, string gridfs, string filename) throws GLib.Error;
					public void upload_file_thread (string database, string gridfs, string filename, Kangaroo.Model.Contracts.Progressor progressor) throws GLib.Error;
					public Kangaroo.Providers.Supports.MongoDBProvider primary { get; }
				}
				[CCode (cheader_filename = "illuminate.h")]
				public class MongoDBExplorer : GLib.Object, Kangaroo.Illuminate.Contracts.Database.IExplorable {
					protected weak Kangaroo.Illuminate.Contracts.Database.IConnection m_connection;
					public MongoDBExplorer (Kangaroo.Illuminate.Contracts.Database.IConnection conn);
					protected virtual Kangaroo.Model.Data.TableModel load_assemblys (string database) throws GLib.Error;
					protected virtual Kangaroo.Model.Data.TableModel load_collections (string schema, string extra_data, int records_max = -1, Kangaroo.Model.Data.TableModel? live_model = null) throws GLib.Error;
					protected virtual Kangaroo.Model.Data.TableModel load_endpoints (string schema, string type) throws GLib.Error;
					protected virtual Kangaroo.Model.Data.TableModel load_functions (string schema) throws GLib.Error;
					protected virtual Kangaroo.Model.Data.TableModel load_operators (string schema) throws GLib.Error;
					protected virtual Kangaroo.Model.Data.TableModel load_partitions (string schema) throws GLib.Error;
					protected virtual Kangaroo.Model.Data.TableModel load_replicas (string server_id) throws GLib.Error;
					protected virtual Kangaroo.Model.Data.TableModel load_roles (string schema) throws GLib.Error;
					protected virtual Kangaroo.Model.Data.TableModel load_schemas (string schema) throws GLib.Error;
					protected virtual Kangaroo.Model.Data.TableModel load_servers (string schema, string extra_data = "nodes") throws GLib.Error;
					protected virtual Kangaroo.Model.Data.TableModel load_shards () throws GLib.Error;
					protected virtual Kangaroo.Model.Data.TableModel load_users (string schema) throws GLib.Error;
					protected virtual Kangaroo.Model.Data.TableModel load_views (string schema, string extra_data, int records_max = -1, Kangaroo.Model.Data.TableModel? live_model = null) throws GLib.Error;
				}
				[CCode (cheader_filename = "illuminate.h")]
				public class MongoDBInspector : GLib.Object, Kangaroo.Illuminate.Contracts.Database.IInspectable {
					public MongoDBInspector (Kangaroo.Illuminate.Contracts.Database.IConnection conn);
					public string template (string operator, out string template = null);
				}
				[CCode (cheader_filename = "illuminate.h")]
				public class MongoDBStatement : Kangaroo.Illuminate.Supports.Database.Statement {
					public MongoDBStatement (Kangaroo.Illuminate.Contracts.Database.IConnection connection);
					public override string build_connection_string (Kangaroo.Model.Setting.Server server);
					public override string build_explain (string statement, string format = "");
					public override string call_function (string database, string user_schema, string function, string parameters);
					public override string call_procedure (string database, string user_schema, string procedure, string parameters);
					public override string change_database (string database);
					public override string commit (string name);
					public override string drop_object (Kangaroo.Model.Meta.DBObject object_type, string database, string user_schema, string object_name, string object_target = "");
					public override string empty_table (string database, string user_schema, string table);
					public override string parse_expression (Kangaroo.Model.Data.DataType data_type, string expression);
					public override string parse_joinable (string symbol, string expression);
					public override string rename_object (Kangaroo.Model.Meta.DBObject object_type, string database, string user_schema, string old_name, string new_name);
					public override string rollback (string name);
					public override string show_content (string database, string user_schema, string table, string columns = "*", string where = "", string order = "", int64 offset = 0, int limit = -1);
					public override string show_databases (out int name_index = null);
					public override string show_table_schemas (string database, out int name_index = null);
					public override string transaction (string name);
				}
				[CCode (cheader_filename = "illuminate.h")]
				public class MySQLAdapterV5x : Kangaroo.Illuminate.Supports.Database.MySQLAdapterV8x {
					public MySQLAdapterV5x (Kangaroo.Illuminate.Contracts.Database.IConnection connection);
					protected override void fill_meta_database (Kangaroo.Model.Meta.MetaDatabase database, bool with_deep = false, bool with_additional = true) throws GLib.Error;
					protected override Kangaroo.Model.Meta.MetaTable fill_schema_table_check (Kangaroo.Model.Meta.MetaTable table) throws GLib.Error;
					protected override void load_relation (Kangaroo.Model.Meta.MetaRelation relation);
				}
				[CCode (cheader_filename = "illuminate.h")]
				public class MySQLAdapterV8x : Kangaroo.Illuminate.Supports.Database.Adapter {
					public MySQLAdapterV8x (Kangaroo.Illuminate.Contracts.Database.IConnection connection);
					protected virtual void fill_meta_database (Kangaroo.Model.Meta.MetaDatabase database, bool with_deep = false, bool with_additional = true) throws GLib.Error;
					public override void fill_meta_object (Kangaroo.Model.Meta.MetaObject meta_object, bool with_deep = false, bool with_additional = true) throws GLib.Error;
					protected void fill_meta_schema (Kangaroo.Model.Meta.MetaSchema schema, bool with_deep = false, bool with_additional = true) throws GLib.Error;
					protected virtual Kangaroo.Model.Meta.MetaTable fill_schema_table_check (Kangaroo.Model.Meta.MetaTable table) throws GLib.Error;
					protected Kangaroo.Model.Meta.MetaTable fill_schema_table_options (Kangaroo.Model.Meta.MetaTable table) throws GLib.Error;
					public override void load_privileges (Gee.HashMap<string,string> matrix, string[] filters = new string[0] { }) throws GLib.Error;
					protected virtual void load_relation (Kangaroo.Model.Meta.MetaRelation relation) throws GLib.Error;
				}
				[CCode (cheader_filename = "illuminate.h")]
				public class MySQLConnection : Kangaroo.Illuminate.Supports.Database.ConnectionImpl {
					public MySQLConnection ();
					public override Kangaroo.Illuminate.Contracts.Database.IAdaptable adapter ();
					public override Kangaroo.Illuminate.Contracts.Database.IBuildable builder ();
					public override Kangaroo.Illuminate.Contracts.Database.IExplorable explorer ();
					public override Kangaroo.Illuminate.Contracts.Database.IInspectable inspector ();
					public override Kangaroo.Illuminate.Contracts.Database.IStatement statement ();
					protected override void update_version () throws GLib.Error;
				}
				[CCode (cheader_filename = "illuminate.h")]
				public class MySQLExplorer : GLib.Object, Kangaroo.Illuminate.Contracts.Database.IExplorable {
					public MySQLExplorer (Kangaroo.Illuminate.Contracts.Database.IConnection conn);
				}
				[CCode (cheader_filename = "illuminate.h")]
				public class MySQLInspector : GLib.Object, Kangaroo.Illuminate.Contracts.Database.IInspectable {
					public MySQLInspector (Kangaroo.Illuminate.Contracts.Database.IConnection conn);
				}
				[CCode (cheader_filename = "illuminate.h")]
				public class MySQLStatement : Kangaroo.Illuminate.Supports.Database.Statement {
					public MySQLStatement (Kangaroo.Illuminate.Contracts.Database.IConnection connection);
					public override string active_database ();
					public override string build_analyze (string statement, string format = "");
					public override string build_connection_string (Kangaroo.Model.Setting.Server server);
					public override string build_explain (string statement, string format = "");
					public override string call_function (string database, string user_schema, string function, string parameters);
					public override string call_procedure (string database, string user_schema, string procedure, string parameters);
					public override string change_database (string database);
					public override string drop_object (Kangaroo.Model.Meta.DBObject object_type, string database, string user_schema, string object_name, string object_target = "");
					public override string empty_table (string database, string user_schema, string table);
					public override string flush_privileges ();
					public override string grant_user_rights (string database, string user_schema, string username, string object, string rights);
					public override string parse_expression (Kangaroo.Model.Data.DataType data_type, string expression);
					public override string rename_object (Kangaroo.Model.Meta.DBObject object_type, string database, string user_schema, string old_name, string new_name);
					public override string revoke_user_rights (string database, string user_schema, string username, string object, string rights);
					public override string show_checks (string database, string user_schema = "", out int name_index = null);
					public override string show_content (string database, string user_schema, string table, string columns = "*", string where = "", string order = "", int64 offset = 0, int limit = -1);
					public override string show_databases (out int name_index = null);
					public override string show_effected (string database, string user_schema, string table, string where = "");
					public override string show_foreigns (string database, string user_schema = "", out int name_index = null);
					public override string show_functions (string database, string user_schema = "", out int name_index = null);
					public override string show_indexes (string database, string user_schema = "", out int name_index = null);
					public override string show_privileges (out int index_privilege, out int index_context);
					public override string show_procedures (string database, string user_schema = "", out int name_index = null);
					public override string show_role_detail (string database, string user_schema, string rolename);
					public override string show_role_rights (string database, string user_schema, string rolename);
					public override string show_roles (string database, string user_schema = "", out int name_index = null);
					public override string show_source (Kangaroo.Model.Meta.DBObject object_type, string database, string user_schema, string name, out int stmt_index = null);
					public override string show_structure (string database, string user_schema, string table, out int name_index = null);
					public override string show_table_schemas (string database, out int name_index = null);
					public override string show_table_spaces (string database, out int name_index = null);
					public override string show_tables (string database, string user_schema = "", out int name_index = null);
					public override string show_triggers (string database, string user_schema = "", out int name_index = null);
					public override string show_uniques (string database, string user_schema = "", out int name_index = null);
					public override string show_user_detail (string database, string user_schema, string username);
					public override string show_user_rights (string database, string user_schema, string username);
					public override string show_users (string database, string user_schema = "", out int name_index = null);
					public override string show_views (string database, string user_schema = "", out int name_index = null);
				}
				[CCode (cheader_filename = "illuminate.h")]
				public class OdbcAdapter : Kangaroo.Illuminate.Supports.Database.Adapter {
					public OdbcAdapter (Kangaroo.Illuminate.Contracts.Database.IConnection connection);
					public override void fill_meta_object (Kangaroo.Model.Meta.MetaObject meta_object, bool with_deep = false, bool with_additional = true) throws GLib.Error;
				}
				[CCode (cheader_filename = "illuminate.h")]
				public class OdbcConnection : Kangaroo.Illuminate.Supports.Database.ConnectionImpl {
					public OdbcConnection ();
					public override Kangaroo.Illuminate.Contracts.Database.IAdaptable adapter ();
					public override Kangaroo.Illuminate.Contracts.Database.IBuildable builder ();
					public override Kangaroo.Illuminate.Contracts.Database.IExplorable explorer ();
					public override Kangaroo.Illuminate.Contracts.Database.IInspectable inspector ();
					public override Kangaroo.Illuminate.Contracts.Database.IStatement statement ();
				}
				[CCode (cheader_filename = "illuminate.h")]
				public class OdbcExplorer : GLib.Object, Kangaroo.Illuminate.Contracts.Database.IExplorable {
					public OdbcExplorer (Kangaroo.Illuminate.Contracts.Database.IConnection conn);
				}
				[CCode (cheader_filename = "illuminate.h")]
				public class OdbcInspector : GLib.Object, Kangaroo.Illuminate.Contracts.Database.IInspectable {
					public OdbcInspector (Kangaroo.Illuminate.Contracts.Database.IConnection conn);
				}
				[CCode (cheader_filename = "illuminate.h")]
				public class OdbcStatement : Kangaroo.Illuminate.Supports.Database.Statement {
					public OdbcStatement (Kangaroo.Illuminate.Contracts.Database.IConnection connection);
					public override string build_connection_string (Kangaroo.Model.Setting.Server server);
					public override string call_function (string database, string user_schema, string function, string parameters);
					public override string call_procedure (string database, string user_schema, string procedure, string parameters);
					public override string drop_object (Kangaroo.Model.Meta.DBObject object_type, string database, string object_schema, string object_name, string object_target = "");
					public override string empty_table (string database, string object_schema, string table);
					public override string rename_object (Kangaroo.Model.Meta.DBObject object_type, string database, string object_schema, string old_name, string new_name);
					public override string show_content (string database, string object_schema, string table, string columns = "*", string where = "", string order = "", int64 offset = 0, int limit = -1);
					public override string show_effected (string database, string object_schema, string table, string where = "");
				}
				[CCode (cheader_filename = "illuminate.h")]
				public class OracleAdapter : Kangaroo.Illuminate.Supports.Database.Adapter {
					protected const string[] TYPE_LIST_CHARACTER;
					protected const string[] TYPE_LIST_DATETIME;
					protected const string[] TYPE_LIST_FLOATS;
					protected const string[] TYPE_LIST_FUNCTION;
					protected const string[] TYPE_LIST_NUMERIC;
					protected const string[] TYPE_LIST_TABLE_FUNCTION;
					protected const string[] USER_LIST_INTERNAL;
					public OracleAdapter (Kangaroo.Illuminate.Contracts.Database.IConnection connection);
					protected virtual void fill_meta_database (Kangaroo.Model.Meta.MetaDatabase database, bool with_deep = false, bool with_additional = true) throws GLib.Error;
					protected virtual void fill_meta_materialized (Kangaroo.Model.Meta.Materialized view) throws GLib.Error;
					public override void fill_meta_object (Kangaroo.Model.Meta.MetaObject meta_object, bool with_deep = false, bool with_additional = true) throws GLib.Error;
					protected virtual void fill_meta_routine (Kangaroo.Model.Meta.MetaRoutine routine) throws GLib.Error;
					protected virtual void fill_meta_schema (Kangaroo.Model.Meta.MetaSchema schema, bool with_deep = false, bool with_additional = true) throws GLib.Error;
					protected virtual void fill_meta_user (Kangaroo.Model.Meta.MetaUser meta_user) throws GLib.Error;
					protected virtual void fill_meta_view (Kangaroo.Model.Meta.MetaView view) throws GLib.Error;
					protected virtual Kangaroo.Model.Meta.MetaTable fill_schema_table_check (Kangaroo.Model.Meta.MetaTable table) throws GLib.Error;
					protected virtual Kangaroo.Model.Meta.MetaTable fill_schema_table_columns (Kangaroo.Model.Meta.MetaTable table) throws GLib.Error;
					protected virtual Kangaroo.Model.Meta.MetaTable fill_schema_table_options (Kangaroo.Model.Meta.MetaTable table) throws GLib.Error;
					protected virtual Kangaroo.Model.Meta.MetaTable fill_schema_table_trigger (Kangaroo.Model.Meta.MetaTable table) throws GLib.Error;
					protected virtual Kangaroo.Model.Meta.MetaTable fill_schema_table_unique (Kangaroo.Model.Meta.MetaTable table) throws GLib.Error;
					public override void load_privileges (Gee.HashMap<string,string> matrix, string[] filters = new string[0] { }) throws GLib.Error;
					protected virtual void load_relation (Kangaroo.Model.Meta.MetaUser user) throws GLib.Error;
				}
				[CCode (cheader_filename = "illuminate.h")]
				public class OracleAdapterV11 : Kangaroo.Illuminate.Supports.Database.OracleAdapter {
					public OracleAdapterV11 (Kangaroo.Illuminate.Contracts.Database.IConnection connection);
					protected override void fill_meta_materialized (Kangaroo.Model.Meta.Materialized view) throws GLib.Error;
					protected override void fill_meta_routine (Kangaroo.Model.Meta.MetaRoutine routine) throws GLib.Error;
					protected override void fill_meta_view (Kangaroo.Model.Meta.MetaView view) throws GLib.Error;
					protected override Kangaroo.Model.Meta.MetaTable fill_schema_table_columns (Kangaroo.Model.Meta.MetaTable table) throws GLib.Error;
					protected override Kangaroo.Model.Meta.MetaTable fill_schema_table_options (Kangaroo.Model.Meta.MetaTable table) throws GLib.Error;
				}
				[CCode (cheader_filename = "illuminate.h")]
				public class OracleBuilder : Kangaroo.Illuminate.Supports.Database.SqlBuilder {
					public OracleBuilder (Kangaroo.Illuminate.Contracts.Database.IConnection connection);
					public override string build_caller (Kangaroo.Model.Meta.MetaRoutine routine);
					public override string build_create (Kangaroo.Model.Meta.MetaObject meta_object, bool native_first = true);
					public override string build_delete (Kangaroo.Model.Meta.MetaObject meta_object);
					protected virtual string build_materialized_script (Kangaroo.Model.Meta.Materialized view, bool is_patch = false);
					public override string build_patch (Kangaroo.Model.Meta.MetaObject meta_object, bool native_first = true);
					protected override string build_sql_delete (string schema, string table, string[] columns, string[] values);
					protected override string build_sql_insert (string schema, string table, string[] columns, string[] values);
					protected override string build_sql_update (string schema, string table, string[] update_columns, string[] update_values, string[] where_columns, string[] where_values);
					public string patch_database (Kangaroo.Model.Meta.MetaDatabase database);
					public override string quote_id_full (string identifier, string separator = ".", string replacement = "*");
					public override string quote_id_names (string[] names, string separator = ".");
					public override string quote_id_object (Kangaroo.Model.Meta.MetaObject object, bool include_database = false);
					public override string quote_value (Kangaroo.Model.Data.DataType data_type, string raw_value);
					public GLib.Regex regex_parameter { get; }
				}
				[CCode (cheader_filename = "illuminate.h")]
				public class OracleBuilderV11 : Kangaroo.Illuminate.Supports.Database.OracleBuilder {
					public OracleBuilderV11 (Kangaroo.Illuminate.Contracts.Database.IConnection connection);
					protected override string build_materialized_script (Kangaroo.Model.Meta.Materialized view, bool is_patch = false);
				}
				[CCode (cheader_filename = "illuminate.h")]
				public class OracleConnection : Kangaroo.Illuminate.Supports.Database.ConnectionImpl {
					public OracleConnection ();
					public override Kangaroo.Illuminate.Contracts.Database.IAdaptable adapter ();
					public override Kangaroo.Illuminate.Contracts.Database.IBuildable builder ();
					public override Kangaroo.Illuminate.Contracts.Database.IExplorable explorer ();
					public override Kangaroo.Illuminate.Contracts.Database.IInspectable inspector ();
					public override Kangaroo.Illuminate.Contracts.Database.IStatement statement ();
					protected override void update_version () throws GLib.Error;
				}
				[CCode (cheader_filename = "illuminate.h")]
				public class OracleExplorer : GLib.Object, Kangaroo.Illuminate.Contracts.Database.IExplorable {
					protected weak Kangaroo.Illuminate.Contracts.Database.IConnection m_connection;
					public OracleExplorer (Kangaroo.Illuminate.Contracts.Database.IConnection conn);
					protected virtual Kangaroo.Model.Data.TableModel load_assemblys (string schema) throws GLib.Error;
					protected virtual Kangaroo.Model.Data.TableModel load_clusters (string schema) throws GLib.Error;
					protected virtual Kangaroo.Model.Data.TableModel load_dblink (string schema, string extra_data = "") throws GLib.Error;
					protected virtual Kangaroo.Model.Data.TableModel load_dimensions (string schema) throws GLib.Error;
					protected virtual Kangaroo.Model.Data.TableModel load_directories (string schema) throws GLib.Error;
					protected virtual Kangaroo.Model.Data.TableModel load_functions (string schema) throws GLib.Error;
					protected virtual Kangaroo.Model.Data.TableModel load_indexes (string schema) throws GLib.Error;
					protected virtual Kangaroo.Model.Data.TableModel load_java_object (string schema, string extra_data) throws GLib.Error;
					protected virtual Kangaroo.Model.Data.TableModel load_materializeds (string schema) throws GLib.Error;
					protected virtual Kangaroo.Model.Data.TableModel load_mview_logs (string schema) throws GLib.Error;
					protected virtual Kangaroo.Model.Data.TableModel load_packages (string schema) throws GLib.Error;
					protected virtual Kangaroo.Model.Data.TableModel load_parameters (string schema) throws GLib.Error;
					protected virtual Kangaroo.Model.Data.TableModel load_procedures (string schema) throws GLib.Error;
					protected virtual Kangaroo.Model.Data.TableModel load_recycles (string schema) throws GLib.Error;
					protected virtual Kangaroo.Model.Data.TableModel load_roles (string schema) throws GLib.Error;
					protected virtual Kangaroo.Model.Data.TableModel load_routines (string schema) throws GLib.Error;
					protected virtual Kangaroo.Model.Data.TableModel load_schemas (string schema) throws GLib.Error;
					protected virtual Kangaroo.Model.Data.TableModel load_sequences (string schema) throws GLib.Error;
					protected virtual Kangaroo.Model.Data.TableModel load_synonyms (string schema, string extra_data) throws GLib.Error;
					protected virtual Kangaroo.Model.Data.TableModel load_tables (string schema) throws GLib.Error;
					protected virtual Kangaroo.Model.Data.TableModel load_tablespaces (string schema) throws GLib.Error;
					protected virtual Kangaroo.Model.Data.TableModel load_tablespaces18 (string schema) throws GLib.Error;
					protected virtual Kangaroo.Model.Data.TableModel load_triggers (string schema) throws GLib.Error;
					protected virtual Kangaroo.Model.Data.TableModel load_types (string schema) throws GLib.Error;
					protected virtual Kangaroo.Model.Data.TableModel load_users (string schema) throws GLib.Error;
					protected virtual Kangaroo.Model.Data.TableModel load_views (string schema) throws GLib.Error;
				}
				[CCode (cheader_filename = "illuminate.h")]
				public class OracleExplorerV11 : Kangaroo.Illuminate.Supports.Database.OracleExplorer {
					public OracleExplorerV11 (Kangaroo.Illuminate.Contracts.Database.IConnection conn);
					protected override Kangaroo.Model.Data.TableModel load_dblink (string schema, string extra_data = "") throws GLib.Error;
					protected override Kangaroo.Model.Data.TableModel load_functions (string schema) throws GLib.Error;
					protected override Kangaroo.Model.Data.TableModel load_materializeds (string schema) throws GLib.Error;
					protected override Kangaroo.Model.Data.TableModel load_packages (string schema) throws GLib.Error;
					protected override Kangaroo.Model.Data.TableModel load_parameters (string schema) throws GLib.Error;
					protected override Kangaroo.Model.Data.TableModel load_procedures (string schema) throws GLib.Error;
					protected override Kangaroo.Model.Data.TableModel load_roles (string schema) throws GLib.Error;
					protected override Kangaroo.Model.Data.TableModel load_routines (string schema) throws GLib.Error;
					protected override Kangaroo.Model.Data.TableModel load_schemas (string schema) throws GLib.Error;
					protected override Kangaroo.Model.Data.TableModel load_sequences (string schema) throws GLib.Error;
					protected override Kangaroo.Model.Data.TableModel load_synonyms (string schema, string extra_data) throws GLib.Error;
					protected override Kangaroo.Model.Data.TableModel load_tables (string schema) throws GLib.Error;
					protected override Kangaroo.Model.Data.TableModel load_tablespaces (string schema) throws GLib.Error;
					protected override Kangaroo.Model.Data.TableModel load_users (string schema) throws GLib.Error;
					protected override Kangaroo.Model.Data.TableModel load_views (string schema) throws GLib.Error;
				}
				[CCode (cheader_filename = "illuminate.h")]
				public class OracleInspector : GLib.Object, Kangaroo.Illuminate.Contracts.Database.IInspectable {
					public OracleInspector (Kangaroo.Illuminate.Contracts.Database.IConnection conn);
				}
				[CCode (cheader_filename = "illuminate.h")]
				public class OracleStatement : Kangaroo.Illuminate.Supports.Database.Statement {
					public OracleStatement (Kangaroo.Illuminate.Contracts.Database.IConnection connection);
					public override string active_database ();
					public override string build_connection_string (Kangaroo.Model.Setting.Server server);
					public override string call_function (string database, string user_schema, string function, string parameters);
					public override string call_procedure (string database, string user_schema, string procedure, string parameters);
					public override string change_database (string database);
					public override string commit (string name);
					public override string drop_object (Kangaroo.Model.Meta.DBObject object_type, string database, string object_schema, string object_name, string object_target = "");
					public override string empty_table (string database, string object_schema, string table);
					public override string grant_role_rights (string database, string schema, string rolename, string object, string rights);
					public override string grant_user_rights (string database, string schema, string username, string object, string rights);
					public override string parse_expression (Kangaroo.Model.Data.DataType data_type, string expression);
					public override string rename_object (Kangaroo.Model.Meta.DBObject object_type, string database, string object_schema, string old_name, string new_name);
					public override string revoke_role_rights (string database, string schema, string rolename, string object, string rights);
					public override string revoke_user_rights (string database, string schema, string username, string object, string rights);
					public override string rollback (string name);
					public override string show_content (string database, string object_schema, string table, string columns = "*", string where = "", string order = "", int64 offset = 0, int limit = -1);
					public override string show_databases (out int name_index = null);
					public override string show_effected (string database, string object_schema, string table, string where = "");
					public override string show_functions (string database, string object_schema = "", out int name_index = null);
					public override string show_indexes (string database, string user_schema = "", out int name_index = null);
					public override string show_privileges (out int index_privilege, out int index_context);
					public override string show_procedures (string database, string object_schema = "", out int name_index = null);
					public override string show_role_detail (string database, string user_schema, string rolename);
					public override string show_role_rights (string database, string user_schema, string rolename);
					public override string show_roles (string database, string user_schema = "", out int name_index = null);
					public override string show_source (Kangaroo.Model.Meta.DBObject object_type, string database, string user_schema, string name, out int stmt_index = null);
					public override string show_structure (string database, string schema, string table, out int name_index = null);
					public override string show_table_schemas (string database, out int name_index = null);
					public override string show_table_spaces (string database, out int name_index = null);
					public override string show_tables (string database, string object_schema = "", out int name_index = null);
					public override string show_triggers (string database, string user_schema = "", out int name_index = null);
					public override string show_user_detail (string database, string user_schema, string username);
					public override string show_user_rights (string database, string user_schema, string username);
					public override string show_users (string database, string user_schema = "", out int name_index = null);
					public override string show_views (string database, string object_schema = "", out int name_index = null);
					public override string transaction (string name);
				}
				[CCode (cheader_filename = "illuminate.h")]
				public class PostgreSQLAdapterV11x : Kangaroo.Illuminate.Supports.Database.Adapter {
					public PostgreSQLAdapterV11x (Kangaroo.Illuminate.Contracts.Database.IConnection connection);
					public override void fill_meta_object (Kangaroo.Model.Meta.MetaObject meta_object, bool with_deep = false, bool with_additional = true) throws GLib.Error;
					protected virtual Kangaroo.Model.Meta.MetaTable fill_schema_table_check (Kangaroo.Model.Meta.MetaTable table) throws GLib.Error;
					protected virtual Kangaroo.Model.Meta.MetaTable fill_schema_table_columns (Kangaroo.Model.Meta.MetaTable table) throws GLib.Error;
					protected virtual Kangaroo.Model.Meta.MetaTable fill_schema_table_foreign (Kangaroo.Model.Meta.MetaTable table) throws GLib.Error;
					protected virtual Kangaroo.Model.Meta.MetaTable fill_schema_table_options (Kangaroo.Model.Meta.MetaTable table) throws GLib.Error;
					protected virtual Kangaroo.Model.Meta.MetaTable fill_schema_table_unique (Kangaroo.Model.Meta.MetaTable table) throws GLib.Error;
					protected string get_full_action_name (string action);
					public override void load_privileges (Gee.HashMap<string,string> matrix, string[] filters = new string[0] { }) throws GLib.Error;
					protected virtual void load_relation (Kangaroo.Model.Meta.MetaRelation relation) throws GLib.Error;
				}
				[CCode (cheader_filename = "illuminate.h")]
				public class PostgreSQLAdapterV12x : Kangaroo.Illuminate.Supports.Database.PostgreSQLAdapterV11x {
					public PostgreSQLAdapterV12x (Kangaroo.Illuminate.Contracts.Database.IConnection connection);
					protected override Kangaroo.Model.Meta.MetaTable fill_schema_table_check (Kangaroo.Model.Meta.MetaTable table) throws GLib.Error;
					protected override Kangaroo.Model.Meta.MetaTable fill_schema_table_foreign (Kangaroo.Model.Meta.MetaTable table) throws GLib.Error;
					protected override Kangaroo.Model.Meta.MetaTable fill_schema_table_options (Kangaroo.Model.Meta.MetaTable table) throws GLib.Error;
					protected override Kangaroo.Model.Meta.MetaTable fill_schema_table_unique (Kangaroo.Model.Meta.MetaTable table) throws GLib.Error;
				}
				[CCode (cheader_filename = "illuminate.h")]
				public class PostgreSQLAdapterV14x : Kangaroo.Illuminate.Supports.Database.PostgreSQLAdapterV12x {
					public PostgreSQLAdapterV14x (Kangaroo.Illuminate.Contracts.Database.IConnection connection);
					protected override Kangaroo.Model.Meta.MetaTable fill_schema_table_columns (Kangaroo.Model.Meta.MetaTable table) throws GLib.Error;
				}
				[CCode (cheader_filename = "illuminate.h")]
				public class PostgreSQLAdapterV9x : Kangaroo.Illuminate.Supports.Database.PostgreSQLAdapterV11x {
					public PostgreSQLAdapterV9x (Kangaroo.Illuminate.Contracts.Database.IConnection connection);
					protected override Kangaroo.Model.Meta.MetaTable fill_schema_table_options (Kangaroo.Model.Meta.MetaTable table) throws GLib.Error;
				}
				[CCode (cheader_filename = "illuminate.h")]
				public class PostgreSQLConnection : Kangaroo.Illuminate.Supports.Database.ConnectionImpl {
					public PostgreSQLConnection ();
					public override Kangaroo.Illuminate.Contracts.Database.IAdaptable adapter ();
					public override Kangaroo.Illuminate.Contracts.Database.IBuildable builder ();
					public override Kangaroo.Illuminate.Contracts.Database.IExplorable explorer ();
					public override Kangaroo.Illuminate.Contracts.Database.IInspectable inspector ();
					public override Kangaroo.Illuminate.Contracts.Database.IStatement statement ();
					protected override void update_version () throws GLib.Error;
				}
				[CCode (cheader_filename = "illuminate.h")]
				public class PostgreSQLExplorer : GLib.Object, Kangaroo.Illuminate.Contracts.Database.IExplorable {
					public PostgreSQLExplorer (Kangaroo.Illuminate.Contracts.Database.IConnection conn);
				}
				[CCode (cheader_filename = "illuminate.h")]
				public class PostgreSQLInspector : GLib.Object, Kangaroo.Illuminate.Contracts.Database.IInspectable {
					public PostgreSQLInspector (Kangaroo.Illuminate.Contracts.Database.IConnection conn);
				}
				[CCode (cheader_filename = "illuminate.h")]
				public class RedisAdapter : Kangaroo.Illuminate.Supports.Database.Adapter {
					protected const string[] TYPE_LIST_CHARACTER;
					public RedisAdapter (Kangaroo.Illuminate.Contracts.Database.IConnection connection);
					protected virtual void fill_meta_database (Kangaroo.Model.Meta.MetaDatabase database, bool with_deep = false, bool with_additional = true) throws GLib.Error;
					public override void fill_meta_object (Kangaroo.Model.Meta.MetaObject meta_object, bool with_deep = false, bool with_additional = true) throws GLib.Error;
					protected virtual void fill_meta_routine (Kangaroo.Model.Meta.MetaRoutine routine) throws GLib.Error;
					protected virtual void fill_meta_schema (Kangaroo.Model.Meta.MetaSchema schema, bool with_deep = false, bool with_additional = true) throws GLib.Error;
					protected virtual void fill_meta_user (Kangaroo.Model.Meta.MetaUser meta_user) throws GLib.Error;
				}
				[CCode (cheader_filename = "illuminate.h")]
				public class RedisBuilder : Kangaroo.Illuminate.Supports.Database.SqlBuilder {
					public RedisBuilder (Kangaroo.Illuminate.Contracts.Database.IConnection connection);
					public override string build_create (Kangaroo.Model.Meta.MetaObject meta_object, bool native_first = true);
					public override string build_delete (Kangaroo.Model.Meta.MetaObject meta_object);
					public override string build_patch (Kangaroo.Model.Meta.MetaObject meta_object, bool native_first = true);
					public GLib.Regex regex_parameter { get; }
				}
				[CCode (cheader_filename = "illuminate.h")]
				public class RedisConnection : Kangaroo.Illuminate.Supports.Database.ConnectionImpl {
					public RedisConnection ();
					public override Kangaroo.Illuminate.Contracts.Database.IAdaptable adapter ();
					public void append_command (string format, ...) throws GLib.Error;
					public void append_command_argv (string[] argv, size_t[] argvlen) throws GLib.Error;
					public override Kangaroo.Illuminate.Contracts.Database.IBuildable builder ();
					public override GLib.Object[] console (string schema, string input_text, out string? prefix = null) throws GLib.Error;
					public override GLib.Object[] execute (string statement, bool with_model = false) throws GLib.Error;
					public Kangaroo.Model.Data.ValueObject execute_args (string format, ...) throws GLib.Error;
					public Kangaroo.Model.Data.ValueObject execute_argv (string[] argv, size_t[] argvlen) throws GLib.Error;
					public override Kangaroo.Model.Data.TableModel execute_as_model (string sql, bool in_thread = false) throws GLib.Error;
					public override async Kangaroo.Model.Data.TableModel execute_as_model_async (string sql) throws GLib.Error;
					public override Kangaroo.Model.Data.ValueObject execute_as_scalar (string sql, bool in_thread = false) throws GLib.Error;
					public override async Kangaroo.Model.Data.ValueObject execute_as_scalar_async (string sql) throws GLib.Error;
					public override async GLib.Object[] execute_async (string statement) throws GLib.Error;
					public int execute_direct () throws GLib.Error;
					public override ssize_t execute_no_query (string statement, bool in_thread = false) throws GLib.Error;
					public override async ssize_t execute_no_query_async (string statement) throws GLib.Error;
					public override Kangaroo.Providers.Contracts.IDataReader execute_reader (string sql) throws GLib.Error;
					public override Kangaroo.Illuminate.Contracts.Database.IExplorable explorer ();
					public uint get_database_count () throws GLib.Error;
					public string get_mode (bool query_real_mode = false) throws GLib.Error;
					public Kangaroo.Providers.Supports.RedisProvider? get_provider_with_host_port (string host_info);
					public override Kangaroo.Illuminate.Contracts.Database.IInspectable inspector ();
					protected override void open_real (Kangaroo.Model.Setting.Server server) throws GLib.Error;
					public Kangaroo.Providers.Supports.RedisProvider? provider (string host_with_port);
					public Kangaroo.Providers.Supports.RedisProvider provider_via_mode ();
					public Kangaroo.Model.Data.ValueObject read_reply_value () throws GLib.Error;
					public void refresh_providers () throws GLib.Error;
					public override Kangaroo.Illuminate.Contracts.Database.IStatement statement ();
					public bool support (string feature_lowercase) throws GLib.Error;
					protected override void update_version () throws GLib.Error;
					public Kangaroo.Illuminate.Supports.Database.RedisNode[] nodes { owned get; }
					public Kangaroo.Providers.Supports.RedisProvider primary { get; }
				}
				[CCode (cheader_filename = "illuminate.h")]
				public class RedisExplorer : GLib.Object, Kangaroo.Illuminate.Contracts.Database.IExplorable {
					protected weak Kangaroo.Illuminate.Contracts.Database.IConnection m_connection;
					public RedisExplorer (Kangaroo.Illuminate.Contracts.Database.IConnection conn);
					protected virtual Kangaroo.Model.Data.TableModel load_assemblys (string schema) throws GLib.Error;
					protected virtual Kangaroo.Model.Data.TableModel load_couples (string schema, string extra_data, int records_max = -1, Kangaroo.Model.Data.TableModel? live_model = null) throws GLib.Error;
					protected virtual void load_couples_node (Kangaroo.Providers.Supports.RedisProvider provider, string schema, string extra_data, int records_max, Kangaroo.Model.Data.TableModel model, Gee.ArrayList<string> cursors, int index = 0) throws GLib.Error;
					protected virtual Kangaroo.Model.Data.TableModel load_databases (string schema) throws GLib.Error;
					protected virtual Kangaroo.Model.Data.TableModel load_endpoints (string schema, string type) throws GLib.Error;
					protected virtual Kangaroo.Model.Data.TableModel load_events (string schema) throws GLib.Error;
					protected virtual Kangaroo.Model.Data.TableModel load_functions (string schema) throws GLib.Error;
					protected virtual Kangaroo.Model.Data.TableModel load_links () throws GLib.Error;
					protected virtual Kangaroo.Model.Data.TableModel load_nodes () throws GLib.Error;
					protected virtual Kangaroo.Model.Data.TableModel load_operators (string schema) throws GLib.Error;
					protected virtual Kangaroo.Model.Data.TableModel load_replicas (string server_id) throws GLib.Error;
					protected virtual Kangaroo.Model.Data.TableModel load_schemas (string schema) throws GLib.Error;
					protected virtual Kangaroo.Model.Data.TableModel load_servers (string schema, string extra_data = "nodes") throws GLib.Error;
					protected virtual Kangaroo.Model.Data.TableModel load_shards () throws GLib.Error;
					protected virtual Kangaroo.Model.Data.TableModel load_users (string schema) throws GLib.Error;
				}
				[CCode (cheader_filename = "illuminate.h")]
				public class RedisExplorerV6x : Kangaroo.Illuminate.Supports.Database.RedisExplorer {
					public RedisExplorerV6x (Kangaroo.Illuminate.Contracts.Database.IConnection conn);
					protected override void load_couples_node (Kangaroo.Providers.Supports.RedisProvider provider, string schema, string extra_data, int records_max, Kangaroo.Model.Data.TableModel model, Gee.ArrayList<string> cursors, int index = 0) throws GLib.Error;
				}
				[CCode (cheader_filename = "illuminate.h")]
				public class RedisExplorerV7x : Kangaroo.Illuminate.Supports.Database.RedisExplorerV6x {
					public RedisExplorerV7x (Kangaroo.Illuminate.Contracts.Database.IConnection conn);
					protected override Kangaroo.Model.Data.TableModel load_functions (string schema) throws GLib.Error;
					protected override Kangaroo.Model.Data.TableModel load_operators (string schema) throws GLib.Error;
				}
				[CCode (cheader_filename = "illuminate.h")]
				public class RedisExplorerV8x : Kangaroo.Illuminate.Supports.Database.RedisExplorerV7x {
					public RedisExplorerV8x (Kangaroo.Illuminate.Contracts.Database.IConnection conn);
					protected override Kangaroo.Model.Data.TableModel load_assemblys (string schema) throws GLib.Error;
				}
				[CCode (cheader_filename = "illuminate.h")]
				public class RedisInspector : GLib.Object, Kangaroo.Illuminate.Contracts.Database.IInspectable {
					public RedisInspector (Kangaroo.Illuminate.Contracts.Database.IConnection conn);
				}
				[CCode (cheader_filename = "illuminate.h")]
				public class RedisNode : GLib.Object {
					public RedisNode ();
					public RedisNode.master (string _id, string hostinfo, string _slots);
					public RedisNode.replica (string _id, string hostinfo, string _master);
					public RedisNode.simple (string _id, string _role, string hostinfo);
					public string to_string ();
					public string host { get; set; }
					public string id { get; set; }
					public string master_id { get; set; }
					public int port { get; set; }
					public Kangaroo.Providers.Supports.RedisProvider? provider { get; set; }
					public string role { get; set; }
					public int slot_end { get; set; }
					public int slot_start { get; set; }
				}
				[CCode (cheader_filename = "illuminate.h")]
				public class RedisPipeline : GLib.Object {
					public RedisPipeline (Kangaroo.Model.Setting.Server server);
					public void append (string command);
					public void clear ();
					public void dump_in_thread (string filename, string schema);
					public void exit_thread ();
					public void run_in_thread ();
					public void set_timeout (uint seconds);
					public signal void pipe_pong (string command, string response, bool is_error, double progress);
				}
				[CCode (cheader_filename = "illuminate.h")]
				public class RedisStatement : Kangaroo.Illuminate.Supports.Database.Statement {
					public RedisStatement (Kangaroo.Illuminate.Contracts.Database.IConnection connection);
					public override string build_connection_string (Kangaroo.Model.Setting.Server server);
					public override string call_function (string database, string user_schema, string function, string parameters);
					public override string call_procedure (string database, string user_schema, string procedure, string parameters);
					public override string change_database (string database);
					public override string commit (string name);
					public override string drop_object (Kangaroo.Model.Meta.DBObject object_type, string database, string user_schema, string object_name, string object_target = "");
					public override string rename_object (Kangaroo.Model.Meta.DBObject object_type, string database, string user_schema, string old_name, string new_name);
					public override string rollback (string name);
					public override string show_databases (out int name_index = null);
					public override string show_table_schemas (string database, out int name_index = null);
					public override string transaction (string name);
				}
				[CCode (cheader_filename = "illuminate.h")]
				public class SQLServerAdapter : Kangaroo.Illuminate.Supports.Database.Adapter {
					protected const string[] TYPE_LIST_CHARACTER;
					protected const string[] TYPE_LIST_DATETIME;
					protected const string[] TYPE_LIST_FLOATS;
					protected const string[] TYPE_LIST_FUNCTION;
					protected const string[] TYPE_LIST_NUMERIC;
					protected const string[] TYPE_LIST_TABLE_FUNCTION;
					protected const string[] USER_LIST_INTERNAL;
					public SQLServerAdapter (Kangaroo.Illuminate.Contracts.Database.IConnection connection);
					protected virtual void fill_meta_database (Kangaroo.Model.Meta.MetaDatabase database, bool with_deep = false, bool with_additional = true) throws GLib.Error;
					public override void fill_meta_object (Kangaroo.Model.Meta.MetaObject meta_object, bool with_deep = false, bool with_additional = true) throws GLib.Error;
					protected virtual void fill_meta_routine (Kangaroo.Model.Meta.MetaRoutine routine) throws GLib.Error;
					protected virtual void fill_meta_schema (Kangaroo.Model.Meta.MetaSchema schema, bool with_deep = false, bool with_additional = true) throws GLib.Error;
					protected virtual void fill_meta_user (Kangaroo.Model.Meta.MetaUser meta_user) throws GLib.Error;
					protected virtual Kangaroo.Model.Meta.MetaTable fill_schema_table_check (Kangaroo.Model.Meta.MetaTable table) throws GLib.Error;
					protected Kangaroo.Model.Meta.MetaTable fill_schema_table_options (Kangaroo.Model.Meta.MetaTable table) throws GLib.Error;
					protected virtual Kangaroo.Model.Meta.MetaTable fill_schema_table_trigger (Kangaroo.Model.Meta.MetaTable table) throws GLib.Error;
					protected virtual Kangaroo.Model.Meta.MetaTable fill_schema_table_unique (Kangaroo.Model.Meta.MetaTable table) throws GLib.Error;
					protected string get_type_name (string type);
					public override void load_privileges (Gee.HashMap<string,string> matrix, string[] filters = new string[0] { }) throws GLib.Error;
					protected virtual void load_relation (Kangaroo.Model.Meta.MetaUser user) throws GLib.Error;
				}
				[CCode (cheader_filename = "illuminate.h")]
				public class SQLServerAdapterV10x : Kangaroo.Illuminate.Supports.Database.SQLServerAdapter {
					public SQLServerAdapterV10x (Kangaroo.Illuminate.Contracts.Database.IConnection connection);
					protected override void fill_meta_database (Kangaroo.Model.Meta.MetaDatabase database, bool with_deep = false, bool with_additional = true) throws GLib.Error;
					protected override void fill_meta_routine (Kangaroo.Model.Meta.MetaRoutine routine) throws GLib.Error;
					protected override void fill_meta_user (Kangaroo.Model.Meta.MetaUser meta_user) throws GLib.Error;
					protected override Kangaroo.Model.Meta.MetaTable fill_schema_table_trigger (Kangaroo.Model.Meta.MetaTable table) throws GLib.Error;
				}
				[CCode (cheader_filename = "illuminate.h")]
				public class SQLServerBuilder : Kangaroo.Illuminate.Supports.Database.SqlBuilder {
					public SQLServerBuilder (Kangaroo.Illuminate.Contracts.Database.IConnection connection);
					public override string build_caller (Kangaroo.Model.Meta.MetaRoutine routine);
					public override string build_create (Kangaroo.Model.Meta.MetaObject meta_object, bool native_first = true);
					public override string build_delete (Kangaroo.Model.Meta.MetaObject meta_object);
					public override string build_patch (Kangaroo.Model.Meta.MetaObject meta_object, bool native_first = true);
					public string patch_database (Kangaroo.Model.Meta.MetaDatabase database);
					public string patch_role (Kangaroo.Model.Meta.MetaRole role);
					public string patch_user (Kangaroo.Model.Meta.MetaUser user);
					public override string quote_id_full (string identifier, string separator = ".", string replacement = "*");
					public override string quote_id_names (string[] names, string separator = ".");
					public override string quote_id_object (Kangaroo.Model.Meta.MetaObject object, bool include_database = false);
					public GLib.Regex regex_parameter { get; }
				}
				[CCode (cheader_filename = "illuminate.h")]
				public class SQLServerConnection : Kangaroo.Illuminate.Supports.Database.ConnectionImpl {
					public SQLServerConnection ();
					public override Kangaroo.Illuminate.Contracts.Database.IAdaptable adapter ();
					public override Kangaroo.Illuminate.Contracts.Database.IBuildable builder ();
					public override Kangaroo.Illuminate.Contracts.Database.IExplorable explorer ();
					public override Kangaroo.Illuminate.Contracts.Database.IInspectable inspector ();
					public override Kangaroo.Illuminate.Contracts.Database.IStatement statement ();
					protected override void update_version () throws GLib.Error;
				}
				[CCode (cheader_filename = "illuminate.h")]
				public class SQLServerExplorer : GLib.Object, Kangaroo.Illuminate.Contracts.Database.IExplorable {
					protected weak Kangaroo.Illuminate.Contracts.Database.IConnection m_connection;
					public SQLServerExplorer (Kangaroo.Illuminate.Contracts.Database.IConnection conn);
					protected virtual Kangaroo.Model.Data.TableModel load_assemblys (string schema) throws GLib.Error;
					protected virtual Kangaroo.Model.Data.TableModel load_databases (string schema) throws GLib.Error;
					protected virtual Kangaroo.Model.Data.TableModel load_devices (string schema) throws GLib.Error;
					protected virtual Kangaroo.Model.Data.TableModel load_endpoints (string schema) throws GLib.Error;
					protected virtual Kangaroo.Model.Data.TableModel load_events (string schema) throws GLib.Error;
					protected virtual Kangaroo.Model.Data.TableModel load_functions (string schema) throws GLib.Error;
					protected virtual Kangaroo.Model.Data.TableModel load_indexes (string schema) throws GLib.Error;
					protected virtual Kangaroo.Model.Data.TableModel load_logins (string schema) throws GLib.Error;
					protected virtual Kangaroo.Model.Data.TableModel load_partition_function (string schema) throws GLib.Error;
					protected virtual Kangaroo.Model.Data.TableModel load_partition_scheme (string schema) throws GLib.Error;
					protected virtual Kangaroo.Model.Data.TableModel load_partitions (string schema, string extra_data) throws GLib.Error;
					protected virtual Kangaroo.Model.Data.TableModel load_procedures (string schema) throws GLib.Error;
					protected virtual Kangaroo.Model.Data.TableModel load_roles_application (string schema) throws GLib.Error;
					protected virtual Kangaroo.Model.Data.TableModel load_roles_database (string schema) throws GLib.Error;
					protected virtual Kangaroo.Model.Data.TableModel load_roles_server (string schema) throws GLib.Error;
					protected virtual Kangaroo.Model.Data.TableModel load_routines (string schema) throws GLib.Error;
					protected virtual Kangaroo.Model.Data.TableModel load_schemas (string schema) throws GLib.Error;
					protected virtual Kangaroo.Model.Data.TableModel load_sequences (string schema) throws GLib.Error;
					protected virtual Kangaroo.Model.Data.TableModel load_servers (string schema) throws GLib.Error;
					protected virtual Kangaroo.Model.Data.TableModel load_statisticses (string schema) throws GLib.Error;
					protected virtual Kangaroo.Model.Data.TableModel load_synonyms (string schema) throws GLib.Error;
					protected virtual Kangaroo.Model.Data.TableModel load_tables (string schema) throws GLib.Error;
					protected virtual Kangaroo.Model.Data.TableModel load_tablespaces (string schema) throws GLib.Error;
					protected virtual Kangaroo.Model.Data.TableModel load_triggers (string schema) throws GLib.Error;
					protected virtual Kangaroo.Model.Data.TableModel load_types (string schema) throws GLib.Error;
					protected virtual Kangaroo.Model.Data.TableModel load_users (string schema) throws GLib.Error;
					protected virtual Kangaroo.Model.Data.TableModel load_views (string schema) throws GLib.Error;
				}
				[CCode (cheader_filename = "illuminate.h")]
				public class SQLServerExplorerV10x : Kangaroo.Illuminate.Supports.Database.SQLServerExplorer {
					public SQLServerExplorerV10x (Kangaroo.Illuminate.Contracts.Database.IConnection conn);
					protected override Kangaroo.Model.Data.TableModel load_functions (string schema) throws GLib.Error;
					protected override Kangaroo.Model.Data.TableModel load_partition_function (string schema) throws GLib.Error;
					protected override Kangaroo.Model.Data.TableModel load_partition_scheme (string schema) throws GLib.Error;
					protected override Kangaroo.Model.Data.TableModel load_procedures (string schema) throws GLib.Error;
					protected override Kangaroo.Model.Data.TableModel load_roles_application (string schema) throws GLib.Error;
					protected override Kangaroo.Model.Data.TableModel load_roles_database (string schema) throws GLib.Error;
					protected override Kangaroo.Model.Data.TableModel load_roles_server (string schema) throws GLib.Error;
					protected override Kangaroo.Model.Data.TableModel load_routines (string schema) throws GLib.Error;
					protected override Kangaroo.Model.Data.TableModel load_servers (string schema) throws GLib.Error;
					protected override Kangaroo.Model.Data.TableModel load_statisticses (string schema) throws GLib.Error;
					protected override Kangaroo.Model.Data.TableModel load_tables (string schema) throws GLib.Error;
					protected override Kangaroo.Model.Data.TableModel load_tablespaces (string schema) throws GLib.Error;
				}
				[CCode (cheader_filename = "illuminate.h")]
				public class SQLServerInspector : GLib.Object, Kangaroo.Illuminate.Contracts.Database.IInspectable {
					public SQLServerInspector (Kangaroo.Illuminate.Contracts.Database.IConnection conn);
				}
				[CCode (cheader_filename = "illuminate.h")]
				public class SQLServerStatement : Kangaroo.Illuminate.Supports.Database.Statement {
					public SQLServerStatement (Kangaroo.Illuminate.Contracts.Database.IConnection connection);
					public override string active_database ();
					public override string build_connection_string (Kangaroo.Model.Setting.Server server);
					public override string call_function (string database, string user_schema, string function, string parameters);
					public override string call_procedure (string database, string user_schema, string procedure, string parameters);
					public override string change_database (string database);
					public override string commit (string name);
					public override string drop_object (Kangaroo.Model.Meta.DBObject object_type, string database, string object_schema, string object_name, string object_target = "");
					public override string empty_table (string database, string object_schema, string table);
					public override string grant_role_rights (string database, string user_schema, string rolename, string object, string rights);
					public override string grant_user_rights (string database, string user_schema, string username, string object, string rights);
					public override string parse_expression (Kangaroo.Model.Data.DataType data_type, string expression);
					public override string rename_object (Kangaroo.Model.Meta.DBObject object_type, string database, string object_schema, string old_name, string new_name);
					public override string revoke_role_rights (string database, string user_schema, string rolename, string object, string rights);
					public override string revoke_user_rights (string database, string user_schema, string username, string object, string rights);
					public override string rollback (string name);
					public override string show_content (string database, string object_schema, string table, string columns = "*", string where = "", string order = "", int64 offset = 0, int limit = -1);
					public override string show_databases (out int name_index = null);
					public override string show_effected (string database, string object_schema, string table, string where = "");
					public override string show_functions (string database, string object_schema = "", out int name_index = null);
					public override string show_indexes (string database, string user_schema = "", out int name_index = null);
					public override string show_privileges (out int index_privilege, out int index_context);
					public override string show_procedures (string database, string object_schema = "", out int name_index = null);
					public override string show_role_detail (string database, string user_schema, string rolename);
					public override string show_role_rights (string database, string user_schema, string rolename);
					public override string show_roles (string database, string user_schema = "", out int name_index = null);
					public override string show_source (Kangaroo.Model.Meta.DBObject object_type, string database, string user_schema, string name, out int stmt_index = null);
					public override string show_structure (string database, string schema, string table, out int name_index = null);
					public override string show_table_schemas (string database, out int name_index = null);
					public override string show_table_spaces (string database, out int name_index = null);
					public override string show_tables (string database, string object_schema = "", out int name_index = null);
					public override string show_triggers (string database, string user_schema = "", out int name_index = null);
					public override string show_user_detail (string database, string user_schema, string username);
					public override string show_user_rights (string database, string user_schema, string username);
					public override string show_users (string database, string user_schema = "", out int name_index = null);
					public override string show_views (string database, string object_schema = "", out int name_index = null);
					public override string transaction (string name);
				}
				[CCode (cheader_filename = "illuminate.h")]
				public class SQLiteAdapter : Kangaroo.Illuminate.Supports.Database.Adapter {
					public SQLiteAdapter (Kangaroo.Illuminate.Contracts.Database.IConnection connection);
					public override void fill_meta_object (Kangaroo.Model.Meta.MetaObject meta_object, bool with_deep = false, bool with_additional = true) throws GLib.Error;
				}
				[CCode (cheader_filename = "illuminate.h")]
				public class SQLiteConnection : Kangaroo.Illuminate.Supports.Database.ConnectionImpl {
					public SQLiteConnection ();
					public override Kangaroo.Illuminate.Contracts.Database.IAdaptable adapter ();
					public override Kangaroo.Illuminate.Contracts.Database.IBuildable builder ();
					public override Kangaroo.Illuminate.Contracts.Database.IExplorable explorer ();
					public override Kangaroo.Illuminate.Contracts.Database.IInspectable inspector ();
					public override Kangaroo.Illuminate.Contracts.Database.IStatement statement ();
					protected override void update_version () throws GLib.Error;
				}
				[CCode (cheader_filename = "illuminate.h")]
				public class SQLiteExplorer : GLib.Object, Kangaroo.Illuminate.Contracts.Database.IExplorable {
					public SQLiteExplorer (Kangaroo.Illuminate.Contracts.Database.IConnection conn);
				}
				[CCode (cheader_filename = "illuminate.h")]
				public class SQLiteInspector : GLib.Object, Kangaroo.Illuminate.Contracts.Database.IInspectable {
					public SQLiteInspector (Kangaroo.Illuminate.Contracts.Database.IConnection conn);
				}
				[CCode (cheader_filename = "illuminate.h")]
				public class SQLiteStatement : Kangaroo.Illuminate.Supports.Database.Statement {
					public SQLiteStatement (Kangaroo.Illuminate.Contracts.Database.IConnection connection);
					public override string build_connection_string (Kangaroo.Model.Setting.Server server);
					public override string call_function (string database, string user_schema, string function, string parameters);
					public override string call_procedure (string database, string user_schema, string procedure, string parameters);
					public override string commit (string name);
					public override string drop_object (Kangaroo.Model.Meta.DBObject object_type, string database, string object_schema, string object_name, string object_target = "");
					public override string empty_table (string database, string object_schema, string table);
					public override string rename_object (Kangaroo.Model.Meta.DBObject object_type, string database, string object_schema, string old_name, string new_name);
					public override string rollback (string name);
					public override string show_content (string database, string object_schema, string table, string columns = "*", string where = "", string order = "", int64 offset = 0, int limit = -1);
					public override string show_databases (out int name_index = null);
					public override string show_effected (string database, string object_schema, string table, string where = "");
					public override string show_functions (string database, string object_schema = "", out int name_index = null);
					public override string show_indexes (string database, string user_schema = "", out int name_index = null);
					public override string show_privileges (out int index_privilege, out int index_context);
					public override string show_procedures (string database, string object_schema = "", out int name_index = null);
					public override string show_source (Kangaroo.Model.Meta.DBObject object_type, string database, string user_schema, string name, out int stmt_index = null);
					public override string show_structure (string database, string object_schema, string table, out int name_index = null);
					public override string show_table_schemas (string database, out int name_index = null);
					public override string show_table_spaces (string database, out int name_index = null);
					public override string show_tables (string database, string object_schema = "", out int name_index = null);
					public override string show_triggers (string database, string user_schema = "", out int name_index = null);
					public override string show_views (string database, string object_schema = "", out int name_index = null);
					public override string transaction (string name);
				}
				[CCode (cheader_filename = "illuminate.h")]
				public class SqlBuilder : GLib.Object, Kangaroo.Illuminate.Contracts.Database.IBuildable {
					protected weak Kangaroo.Illuminate.Contracts.Database.IConnection m_connection;
					public SqlBuilder (Kangaroo.Illuminate.Contracts.Database.IConnection conn);
					public virtual string build_caller (Kangaroo.Model.Meta.MetaRoutine function);
					public virtual string build_create (Kangaroo.Model.Meta.MetaObject meta_object, bool native_first = true);
					public virtual string build_delete (Kangaroo.Model.Meta.MetaObject meta_object);
					public virtual string build_patch (Kangaroo.Model.Meta.MetaObject meta_object, bool native_first = true);
					protected virtual string build_sql_delete (string schema, string table, string[] columns, string[] values);
					protected virtual string build_sql_insert (string schema, string table, string[] columns, string[] values);
					protected virtual string build_sql_update (string schema, string table, string[] update_columns, string[] update_values, string[] where_columns, string[] where_values);
					public virtual string build_with_array (string schema, string table, string[] columns, string[] values, Kangaroo.Illuminate.Contracts.Database.SqlAction action = Kangaroo.Illuminate.Contracts.Database.SqlAction.INSERT, string[] where_columns = new string[0] { }, string[] where_values = new string[0] { });
					public virtual string build_with_dataset (Kangaroo.Model.Data.DataSetModel dataset, Kangaroo.Illuminate.Contracts.Database.SqlAction action = Kangaroo.Illuminate.Contracts.Database.SqlAction.INSERT);
					public virtual string build_with_model (Kangaroo.Model.Data.TableModel model, Kangaroo.Illuminate.Contracts.Database.SqlAction action = Kangaroo.Illuminate.Contracts.Database.SqlAction.INSERT);
					public virtual string build_with_row (Kangaroo.Model.Data.TableModel model, Kangaroo.Model.Data.RowModel row, Kangaroo.Illuminate.Contracts.Database.SqlAction action = Kangaroo.Illuminate.Contracts.Database.SqlAction.INSERT);
					public virtual void order_with_dependence (Kangaroo.Model.Meta.MetaSchema schema, int index = 0);
					public virtual string patch_with_dataset (Kangaroo.Model.Data.DataSetModel dataset);
					public virtual string patch_with_model (Kangaroo.Model.Data.TableModel model);
					public virtual string quote_id_full (string identifier, string separator = ".", string replacement = "*");
					public virtual string quote_id_names (string[] names, string separator = ".");
					public virtual string quote_id_object (Kangaroo.Model.Meta.MetaObject object, bool include_database = false);
					public virtual string quote_value (Kangaroo.Model.Data.DataType data_type, string raw_value);
				}
				[CCode (cheader_filename = "illuminate.h")]
				public class Statement : GLib.Object, Kangaroo.Illuminate.Contracts.Database.IStatement {
					protected weak Kangaroo.Illuminate.Contracts.Database.IConnection m_connection;
					public Statement (Kangaroo.Illuminate.Contracts.Database.IConnection connection);
					public virtual string active_database ();
					public virtual string build_analyze (string statement, string format = "");
					public virtual string build_connection_string (Kangaroo.Model.Setting.Server server);
					public virtual string build_explain (string statement, string format = "");
					public virtual string build_sql_view (string user_schema, string view_name, string statements);
					public virtual string call_function (string database, string user_schema, string function, string parameters);
					public virtual string call_procedure (string database, string user_schema, string procedure, string parameters);
					public virtual string change_database (string database);
					public virtual string commit (string name);
					public virtual string drop_object (Kangaroo.Model.Meta.DBObject object_type, string database, string user_schema, string object_name, string object_target = "");
					public virtual string empty_table (string database, string user_schema, string object_name);
					public virtual string flush_privileges ();
					public virtual string grant_role_rights (string database, string user_schema, string username, string object, string rights);
					public virtual string grant_user_rights (string database, string user_schema, string username, string object, string rights);
					public virtual string parse_expression (Kangaroo.Model.Data.DataType data_type, string expression);
					public virtual string parse_joinable (string joinable, string expression);
					public virtual string rename_object (Kangaroo.Model.Meta.DBObject object_type, string database, string user_schema, string old_name, string new_name);
					public virtual string revoke_role_rights (string database, string user_schema, string username, string object, string rights);
					public virtual string revoke_user_rights (string database, string user_schema, string username, string object, string rights);
					public virtual string rollback (string name);
					public virtual string show_checks (string database, string user_schema = "", out int name_index = null);
					public virtual string show_content (string database, string user_schema, string table, string columns = "*", string where = "", string order = "", int64 offset = 0, int limit = -1);
					public virtual string show_databases (out int name_index = null);
					public virtual string show_effected (string database, string user_schema, string table, string where = "");
					public virtual string show_excludes (string database, string user_schema = "", out int name_index = null);
					public virtual string show_foreigns (string database, string user_schema = "", out int name_index = null);
					public virtual string show_functions (string database, string user_schema = "", out int name_index = null);
					public virtual string show_indexes (string database, string user_schema = "", out int name_index = null);
					public virtual string show_privileges (out int index_privilege, out int index_context);
					public virtual string show_procedures (string database, string user_schema = "", out int name_index = null);
					public virtual string show_role_detail (string database, string user_schema, string rolename);
					public virtual string show_role_rights (string database, string user_schema, string rolename);
					public virtual string show_roles (string database, string user_schema = "", out int name_index = null);
					public virtual string show_rules (string database, string user_schema = "", out int name_index = null);
					public virtual string show_source (Kangaroo.Model.Meta.DBObject object_type, string database, string user_schema, string name, out int stmt_index = null);
					public virtual string show_structure (string database, string user_schema, string table, out int name_index = null);
					public virtual string show_table_schemas (string database, out int name_index = null);
					public virtual string show_table_spaces (string database, out int name_index = null);
					public virtual string show_tables (string database, string user_schema = "", out int name_index = null);
					public virtual string show_triggers (string database, string user_schema = "", out int name_index = null);
					public virtual string show_uniques (string database, string user_schema = "", out int name_index = null);
					public virtual string show_user_detail (string database, string user_schema, string username);
					public virtual string show_user_rights (string database, string user_schema, string username);
					public virtual string show_users (string database, string user_schema = "", out int name_index = null);
					public virtual string show_views (string database, string user_schema = "", out int name_index = null);
					public virtual string transaction (string name);
				}
			}
			namespace Log {
				[CCode (cheader_filename = "illuminate.h")]
				public class ColorFormatter : Kangaroo.Illuminate.Supports.Log.DefaultFormatter {
					public ColorFormatter ();
					public override string format (Kangaroo.Illuminate.Contracts.Log.LogLevel level, string server, string name, string format);
					protected override string get_level_name (Kangaroo.Illuminate.Contracts.Log.LogLevel level);
				}
				[CCode (cheader_filename = "illuminate.h")]
				public class DefaultFormatter : GLib.Object, Kangaroo.Illuminate.Contracts.Log.IFormatter {
					public DefaultFormatter ();
					public virtual string format (Kangaroo.Illuminate.Contracts.Log.LogLevel level, string server, string name, string format);
					protected virtual string get_level_name (Kangaroo.Illuminate.Contracts.Log.LogLevel level);
				}
				[CCode (cheader_filename = "illuminate.h")]
				public class DelegateHandler : GLib.Object, Kangaroo.Illuminate.Contracts.Log.ILogHandler {
					public DelegateHandler ();
					public void initialize (Kangaroo.Illuminate.Supports.Log.PushMessageCallback callback);
				}
				[CCode (cheader_filename = "illuminate.h")]
				public class GLibLogHandler : GLib.Object, Kangaroo.Illuminate.Contracts.Log.ILogHandler {
					public GLibLogHandler ();
				}
				[CCode (cheader_filename = "illuminate.h")]
				public class LogManager : GLib.Object, Kangaroo.Illuminate.Contracts.Log.ILogManager {
					public LogManager ();
				}
				[CCode (cheader_filename = "illuminate.h")]
				public class Logger : GLib.Object, Kangaroo.Illuminate.Contracts.Log.ILogger {
					public Logger (string t_uuid);
				}
				[CCode (cheader_filename = "illuminate.h")]
				public class SimpleFormatter : Kangaroo.Illuminate.Supports.Log.DefaultFormatter {
					public SimpleFormatter ();
					public override string format (Kangaroo.Illuminate.Contracts.Log.LogLevel level, string server, string name, string format);
				}
				[CCode (cheader_filename = "illuminate.h")]
				public class SliceFileLogHandler : GLib.Object, Kangaroo.Illuminate.Contracts.Log.ILogHandler {
					protected GLib.FileOutputStream m_file_stream;
					public SliceFileLogHandler ();
					public virtual void close ();
					public void initialize (string name, string folder, int64 file_size_limit = 1048576) throws GLib.Error;
				}
				[CCode (cheader_filename = "illuminate.h")]
				public class TempFileLogHandler : GLib.Object, Kangaroo.Illuminate.Contracts.Log.ILogHandler {
					public TempFileLogHandler ();
					public virtual void close ();
					public virtual void initialize (string name);
					public virtual void publish (Kangaroo.Illuminate.Contracts.Log.LogLevel level, string server, string name, string format, va_list args);
					public virtual string recent (int64 length = -1);
				}
				[CCode (cheader_filename = "illuminate.h")]
				public delegate void PushMessageCallback (string message);
			}
		}
		namespace Transform {
			[CCode (cheader_filename = "illuminate.h")]
			public class StructureSynchronizer : GLib.Object, Kangaroo.Illuminate.Transform.ITransform, Kangaroo.Illuminate.Transform.ISynchronize {
				public StructureSynchronizer (Gee.HashMap<string,string> _options);
				public Kangaroo.Model.Meta.MetaSchema schema_source { get; }
				public Kangaroo.Model.Meta.MetaSchema schema_target { get; }
			}
			[CCode (cheader_filename = "illuminate.h")]
			public class Transfer : GLib.Object, Kangaroo.Illuminate.Transform.ITransform {
				public Transfer (Gee.HashMap<string,string> _options);
			}
			[CCode (cheader_filename = "illuminate.h")]
			public class UserdataSynchronizer : GLib.Object, Kangaroo.Illuminate.Transform.ITransform, Kangaroo.Illuminate.Transform.ISynchronize {
				public UserdataSynchronizer (Gee.HashMap<string,string> _options);
				public Kangaroo.Model.Data.DataSetModel dataset_source { get; }
				public Kangaroo.Model.Data.DataSetModel dataset_target { get; }
			}
			[CCode (cheader_filename = "illuminate.h")]
			public interface ISynchronize : GLib.Object, Kangaroo.Illuminate.Transform.ITransform {
				public abstract Gee.ArrayList<string> generate () throws GLib.Error;
				public abstract GLib.Object preview () throws GLib.Error;
			}
			[CCode (cheader_filename = "illuminate.h")]
			public interface ITransform : GLib.Object {
				public const int DATA_BATCH_DEFAULT;
				public const string DATA_CHANNEL;
				public const string DATA_DATABASE;
				public const string DATA_OPTION;
				public const string DATA_PREVIEW;
				public const string DATA_PROVIDER;
				public const string DATA_RESULT;
				public const string DATA_SCHEMA;
				public const string DATA_SOURCE;
				public const string DATA_TARGET;
				public const string TARGET_BATCH;
				public const string TARGET_FIELDS;
				public const string TARGET_MODE;
				public const string TARGET_NAME;
				public const string TARGET_RECORDS;
				public const string TARGET_VIEW2TABLE;
				public abstract void handle () throws GLib.Error;
				public abstract void initialize () throws GLib.Error;
				public abstract Kangaroo.Illuminate.Contracts.ThreadProgress progress { get; set; }
				public abstract Kangaroo.Illuminate.Contracts.Database.IConnection server_source { get; set; }
				public abstract Kangaroo.Illuminate.Contracts.Database.IConnection server_target { get; set; }
			}
		}
	}
}
